/*
 * Decompiled with CFR 0.152.
 */
package winniethedampoeh.villagertimetable.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;

public interface Option<T> {
    public String getKey();

    public T get();

    public void set(T var1);

    public JsonElement toJson();

    public void fromJson(JsonElement var1) throws JsonParseException;

    public static interface EnumOption {
        public int getOrdinal();

        public int getMaxOrdinal();

        public String getValueKey();

        public String getTranslationKey();
    }

    public static class RenderLocationOption
    extends BaseOption<RenderLocation> {
        public RenderLocationOption(String key, RenderLocation defaultValue) {
            super(key, defaultValue);
        }

        @Override
        public JsonElement toJson() {
            return new JsonPrimitive(((RenderLocation)this.value).getValueKey());
        }

        @Override
        public void fromJson(JsonElement json) throws JsonParseException {
            switch (json.getAsString()) {
                case "north_east": {
                    this.set(RenderLocation.NORTH_EAST);
                    break;
                }
                case "north_west": {
                    this.set(RenderLocation.NORTH_WEST);
                    break;
                }
                case "south_east": {
                    this.set(RenderLocation.SOUTH_EAST);
                    break;
                }
                case "south_west": {
                    this.set(RenderLocation.SOUTH_WEST);
                    break;
                }
                case "hotbar_left": {
                    this.set(RenderLocation.HOTBAR_LEFT);
                    break;
                }
                case "hotbar_right": {
                    this.set(RenderLocation.HOTBAR_RIGHT);
                    break;
                }
                default: {
                    throw new JsonParseException("Invalid json argument, correct json arguments are: \"north_east\", \"north_west\", \"south_east\", \"south_west\", \"hotbar_left\" and \"hotbar_right\"");
                }
            }
        }

        public static enum RenderLocation implements EnumOption
        {
            NORTH_EAST("north_east"),
            NORTH_WEST("north_west"),
            SOUTH_EAST("south_east"),
            SOUTH_WEST("south_west"),
            HOTBAR_LEFT("hotbar_left"),
            HOTBAR_RIGHT("hotbar_right");

            private final String valueKey;

            private RenderLocation(String valueKey) {
                this.valueKey = valueKey;
            }

            @Override
            public int getOrdinal() {
                return this.ordinal();
            }

            @Override
            public int getMaxOrdinal() {
                return HOTBAR_RIGHT.getOrdinal();
            }

            @Override
            public String getValueKey() {
                return this.valueKey;
            }

            @Override
            public String getTranslationKey() {
                return String.format("options.%s.render_location.%s", "villagertimetable", this.getValueKey());
            }
        }
    }

    public static class TimeFormatOption
    extends BaseOption<TimeFormat> {
        public TimeFormatOption(String key, TimeFormat defaultValue) {
            super(key, defaultValue);
        }

        @Override
        public JsonElement toJson() {
            return new JsonPrimitive(switch (((TimeFormat)this.value).ordinal()) {
                default -> throw new IncompatibleClassChangeError();
                case 0 -> "24h";
                case 1 -> "12h";
                case 2 -> "ticks";
            });
        }

        @Override
        public void fromJson(JsonElement json) throws JsonParseException {
            switch (json.getAsString()) {
                case "24h": {
                    this.set(TimeFormat.H24);
                    break;
                }
                case "12h": {
                    this.set(TimeFormat.H12);
                    break;
                }
                case "ticks": {
                    this.set(TimeFormat.TICKS);
                    break;
                }
                default: {
                    throw new JsonParseException("Invalid json argument. Corract options are \"24h\", \"12h\" and \"ticks\"");
                }
            }
        }

        public static enum TimeFormat implements EnumOption
        {
            H24("24h"),
            H12("12h"),
            TICKS("ticks");

            private final String valueKey;

            private TimeFormat(String valueKey) {
                this.valueKey = valueKey;
            }

            @Override
            public int getMaxOrdinal() {
                return TICKS.ordinal();
            }

            @Override
            public String getValueKey() {
                return this.valueKey;
            }

            @Override
            public String getTranslationKey() {
                return String.format("options.%s.time_format.%s", "villagertimetable", this.getValueKey());
            }

            @Override
            public int getOrdinal() {
                return this.ordinal();
            }
        }
    }

    public static class BooleanOption
    extends BaseOption<Boolean> {
        public BooleanOption(String key, Boolean defaultValue) {
            super(key, defaultValue);
        }

        @Override
        public JsonElement toJson() {
            return new JsonPrimitive((Boolean)this.get());
        }

        @Override
        public void fromJson(JsonElement json) throws JsonParseException {
            if (!json.isJsonPrimitive()) {
                throw new JsonParseException("Json must be a primitive");
            }
            this.set(json.getAsBoolean());
        }
    }

    public static abstract class BaseOption<T>
    implements Option<T> {
        protected final String key;
        protected T value;

        public BaseOption(String key, T defaultValue) {
            this.key = key;
            this.value = defaultValue;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public T get() {
            return this.value;
        }

        @Override
        public void set(T value) {
            this.value = value;
        }
    }
}

