/*
 * Decompiled with CFR 0.152.
 */
package winniethedampoeh.villagertimetable.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterator;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.util.Collections;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;
import org.jetbrains.annotations.Nullable;
import winniethedampoeh.villagertimetable.VillagerTimetable;
import winniethedampoeh.villagertimetable.config.Option;

public class VillagerTimetableConfig {
    public static final VillagerTimetableConfig INSTANCE = new VillagerTimetableConfig(FabricLoader.getInstance().getConfigDir().resolve("villagertimetable.json").toFile());
    protected final File file;
    protected final Object2ObjectLinkedOpenHashMap<String, Option<?>> optionMap = new Object2ObjectLinkedOpenHashMap();
    protected final Map<String, Option<?>> optionMapView = Collections.unmodifiableMap(this.optionMap);
    public final Option.BooleanOption guiRendering = this.addOption(new Option.BooleanOption("hud_rendering", true));
    public final Option.TimeFormatOption timeFormat = this.addOption(new Option.TimeFormatOption("time_format", Option.TimeFormatOption.TimeFormat.H24));
    public final Option.RenderLocationOption renderLocation = this.addOption(new Option.RenderLocationOption("render_location", Option.RenderLocationOption.RenderLocation.SOUTH_WEST));

    public static void loadConfig() {
    }

    public VillagerTimetableConfig(File file) {
        this.file = file;
    }

    public void load() {
        if (this.file.exists()) {
            try (FileReader reader = new FileReader(this.file);){
                this.fromJson(JsonParser.parseReader((Reader)reader));
            }
            catch (Exception e) {
                VillagerTimetable.LOGGER.error("Could not load config from file '" + this.file.getAbsolutePath() + "'", (Throwable)e);
            }
        }
        this.save();
    }

    public void save() {
        try (FileWriter writer = new FileWriter(this.file);){
            VillagerTimetable.GSON.toJson(this.toJson(), (Appendable)writer);
        }
        catch (Exception e) {
            VillagerTimetable.LOGGER.error("Could not save config to file '" + this.file.getAbsolutePath() + "'", (Throwable)e);
        }
    }

    protected void fromJson(JsonElement json) throws JsonParseException {
        if (json.isJsonObject()) {
            JsonObject object = json.getAsJsonObject();
            ObjectBidirectionalIterator iterator = this.optionMap.object2ObjectEntrySet().fastIterator();
            while (iterator.hasNext()) {
                Object2ObjectMap.Entry entry = (Object2ObjectMap.Entry)iterator.next();
                JsonElement element = object.get((String)entry.getKey());
                if (element == null) continue;
                try {
                    ((Option)entry.getValue()).fromJson(element);
                }
                catch (JsonParseException e) {
                    VillagerTimetable.LOGGER.error("Could not read option '" + (String)entry.getKey() + "'", (Throwable)e);
                }
            }
        } else {
            throw new JsonParseException("Json must be an object");
        }
    }

    protected JsonElement toJson() {
        JsonObject object = new JsonObject();
        ObjectBidirectionalIterator iterator = this.optionMap.object2ObjectEntrySet().fastIterator();
        while (iterator.hasNext()) {
            Object2ObjectMap.Entry entry = (Object2ObjectMap.Entry)iterator.next();
            object.add((String)entry.getKey(), ((Option)entry.getValue()).toJson());
        }
        return object;
    }

    protected <T extends Option<?>> T addOption(T option) {
        Option old = (Option)this.optionMap.put((Object)option.getKey(), option);
        if (old != null) {
            VillagerTimetable.LOGGER.warn("Option with key '" + old.getKey() + "' was overridden");
        }
        return option;
    }

    @Nullable
    public Option<?> getOption(String key) {
        return (Option)this.optionMap.get((Object)key);
    }

    public Map<String, Option<?>> getOptionMapView() {
        return this.optionMapView;
    }

    static {
        INSTANCE.load();
    }
}

