/*
 * Decompiled with CFR 0.152.
 */
package lol.ysmu.sellXP;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.command.TabExecutor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;

public final class SellXP
extends JavaPlugin
implements TabExecutor,
Listener {
    private static Economy economy;
    private boolean vaultEnabled = false;
    private final Map<UUID, Long> sellCooldowns = new HashMap<UUID, Long>();
    private long cooldownMillis = 5000L;

    public void onEnable() {
        this.saveDefaultConfig();
        this.vaultEnabled = this.setupEconomy();
        if (!this.vaultEnabled) {
            this.getLogger().warning("Vault not found! Economy features will not work.");
            this.getLogger().warning("Please install Vault and an economy plugin (e.g., EssentialsX)!");
        }
        this.getCommand("sellxp").setExecutor((CommandExecutor)this);
        this.getCommand("sellxp").setTabCompleter((TabCompleter)this);
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getLogger().info("SellXP enabled successfully!");
    }

    public void onDisable() {
        this.getLogger().info("SellXP disabled.");
    }

    private boolean setupEconomy() {
        if (this.getServer().getPluginManager().getPlugin("Vault") == null) {
            return false;
        }
        RegisteredServiceProvider rsp = this.getServer().getServicesManager().getRegistration(Economy.class);
        if (rsp == null) {
            return false;
        }
        economy = (Economy)rsp.getProvider();
        return economy != null;
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (!this.vaultEnabled && player.isOp() && this.getConfig().getBoolean("warn-ops-on-join", true)) {
            player.sendMessage(this.color("&c[SellXP] Vault was not found!"));
            player.sendMessage(this.color("&7This plugin will not function without Vault and an economy plugin."));
            player.sendMessage(this.color("&7Download Vault: &ehttps://www.spigotmc.org/resources/vault.34315/"));
        }
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        FileConfiguration config = this.getConfig();
        if (args.length == 0) {
            this.sendHelp(sender);
            return true;
        }
        String arg = args[0].toUpperCase();
        if (arg.equals("HELP")) {
            this.sendHelp(sender);
            return true;
        }
        if (arg.equals("RELOAD")) {
            if (!sender.hasPermission("sellxp.reload")) {
                sender.sendMessage(this.color(config.getString("messages.no-permission")));
                return true;
            }
            this.reloadConfig();
            sender.sendMessage(this.color(config.getString("messages.reload-success")));
            return true;
        }
        if (!(sender instanceof Player)) {
            sender.sendMessage("Only players can sell XP.");
            return true;
        }
        Player player = (Player)sender;
        if (!this.vaultEnabled) {
            player.sendMessage(this.color(config.getString("messages.no-vault")));
            return true;
        }
        long now = System.currentTimeMillis();
        if (this.sellCooldowns.containsKey(player.getUniqueId()) && now - this.sellCooldowns.get(player.getUniqueId()) < this.cooldownMillis) {
            long remaining = (this.cooldownMillis - (now - this.sellCooldowns.get(player.getUniqueId()))) / 1000L;
            player.sendMessage(this.color("&cYou must wait " + remaining + " seconds before selling again."));
            return true;
        }
        this.sellCooldowns.put(player.getUniqueId(), now);
        boolean isLevel = arg.endsWith("L");
        boolean sellAll = arg.equals("ALL") || arg.equals("ALLL");
        int xpToSell = 0;
        int levelsToSell = 0;
        try {
            if (sellAll) {
                if (isLevel) {
                    levelsToSell = player.getLevel();
                    xpToSell = this.getTotalXpForLevels(player, levelsToSell);
                } else {
                    xpToSell = player.getTotalExperience();
                    levelsToSell = -1;
                }
            } else {
                int value;
                if (isLevel) {
                    arg = arg.substring(0, arg.length() - 1);
                }
                if ((value = Integer.parseInt(arg)) <= 0) {
                    throw new NumberFormatException();
                }
                if (isLevel) {
                    levelsToSell = Math.min(value, player.getLevel());
                    xpToSell = this.getTotalXpForLevels(player, levelsToSell);
                } else {
                    xpToSell = Math.min(value, player.getTotalExperience());
                    levelsToSell = -1;
                }
            }
        }
        catch (NumberFormatException e) {
            player.sendMessage(this.color(config.getString("messages.invalid-number")));
            return true;
        }
        if (isLevel && levelsToSell > config.getInt("max-levels-per-sell", 50)) {
            player.sendMessage(this.color("&cYou can only sell up to " + config.getInt("max-levels-per-sell") + " levels at a time!"));
            return true;
        }
        if (!isLevel && xpToSell > config.getInt("max-xp-per-sell", 500)) {
            player.sendMessage(this.color("&cYou can only sell up to " + config.getInt("max-xp-per-sell") + " XP points at a time!"));
            return true;
        }
        double multiplier = config.getDouble("multiplier", 1.0);
        for (int i = 10; i >= 1; --i) {
            if (!player.hasPermission("sellxp.multiplier." + i)) continue;
            multiplier = i;
            break;
        }
        double pricePerUnit = config.getDouble("price-per-level");
        double totalEarned = (double)xpToSell * pricePerUnit * multiplier;
        this.removePlayerXp(player, xpToSell, levelsToSell);
        economy.depositPlayer((OfflinePlayer)player, totalEarned);
        String message = config.getString("messages.sold").replace("%levels%", String.valueOf(levelsToSell > 0 ? levelsToSell : xpToSell)).replace("%money%", String.format("%.2f", totalEarned)).replace("%multiplier%", String.format("%.2f", multiplier)).replace("%player%", player.getName());
        player.sendMessage(this.color(message));
        return true;
    }

    private void sendHelp(CommandSender sender) {
        FileConfiguration config = this.getConfig();
        sender.sendMessage(this.color(config.getString("messages.help-header")));
        List helpList = config.getStringList("messages.help-list");
        for (String line : helpList) {
            sender.sendMessage(this.color(line));
        }
    }

    private String color(String msg) {
        return msg == null ? "" : msg.replace("&", "\u00a7");
    }

    private void removePlayerXp(Player player, int xp, int levels) {
        if (levels > 0) {
            player.setLevel(player.getLevel() - levels);
        }
        player.giveExp(-xp);
    }

    private int getTotalXpForLevels(Player player, int levels) {
        int totalXp = 0;
        int currentLevel = player.getLevel();
        for (int i = 0; i < levels; ++i) {
            totalXp += this.getXpToNextLevel(currentLevel - i);
        }
        return totalXp;
    }

    private int getXpToNextLevel(int level) {
        if (level >= 0 && level <= 16) {
            return 2 * level + 7;
        }
        if (level >= 17 && level <= 31) {
            return 5 * level - 38;
        }
        return 9 * level - 158;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            completions.add("help");
            completions.add("reload");
            completions.add("all");
        }
        return completions;
    }
}

