/*
 * Decompiled with CFR 0.152.
 */
package net.exavior.lavish.common.particle.custom;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;

public class AmethystGlowParticle
extends TextureSheetParticle {
    static final RandomSource RANDOM = RandomSource.create();
    private final SpriteSet sprites;

    AmethystGlowParticle(ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, SpriteSet sprites) {
        super(level, x, y, z, xSpeed, ySpeed, zSpeed);
        this.friction = 0.96f;
        this.speedUpWhenYMotionIsBlocked = true;
        this.sprites = sprites;
        this.quadSize *= 0.75f;
        this.hasPhysics = false;
        this.setSpriteFromAge(sprites);
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public int getLightColor(float partialTick) {
        float f = ((float)this.age + partialTick) / (float)this.lifetime;
        f = Mth.clamp((float)f, (float)0.0f, (float)1.0f);
        int i = super.getLightColor(partialTick);
        int j = i & 0xFF;
        int k = i >> 16 & 0xFF;
        if ((j += (int)(f * 15.0f * 16.0f)) > 240) {
            j = 240;
        }
        return j | k << 16;
    }

    public void tick() {
        super.tick();
        this.setSpriteFromAge(this.sprites);
    }

    public static class WaxOnProvider
    implements ParticleProvider<SimpleParticleType> {
        private final double SPEED_FACTOR = 0.01;
        private final SpriteSet sprite;

        public WaxOnProvider(SpriteSet sprites) {
            this.sprite = sprites;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            AmethystGlowParticle glowparticle = new AmethystGlowParticle(level, x, y, z, 0.0, 0.0, 0.0, this.sprite);
            glowparticle.setColor(0.91f, 0.55f, 0.08f);
            glowparticle.setParticleSpeed(xSpeed * 0.01 / 2.0, ySpeed * 0.01, zSpeed * 0.01 / 2.0);
            int i = 10;
            int j = 40;
            glowparticle.setLifetime(level.random.nextInt(30) + 10);
            return glowparticle;
        }
    }

    public static class WaxOffProvider
    implements ParticleProvider<SimpleParticleType> {
        private final double SPEED_FACTOR = 0.01;
        private final SpriteSet sprite;

        public WaxOffProvider(SpriteSet sprites) {
            this.sprite = sprites;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            AmethystGlowParticle glowparticle = new AmethystGlowParticle(level, x, y, z, 0.0, 0.0, 0.0, this.sprite);
            glowparticle.setColor(1.0f, 0.9f, 1.0f);
            glowparticle.setParticleSpeed(xSpeed * 0.01 / 2.0, ySpeed * 0.01, zSpeed * 0.01 / 2.0);
            int i = 10;
            int j = 40;
            glowparticle.setLifetime(level.random.nextInt(30) + 10);
            return glowparticle;
        }
    }

    public static class ScrapeProvider
    implements ParticleProvider<SimpleParticleType> {
        private final double SPEED_FACTOR = 0.01;
        private final SpriteSet sprite;

        public ScrapeProvider(SpriteSet sprites) {
            this.sprite = sprites;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            AmethystGlowParticle glowparticle = new AmethystGlowParticle(level, x, y, z, 0.0, 0.0, 0.0, this.sprite);
            if (level.random.nextBoolean()) {
                glowparticle.setColor(0.29f, 0.58f, 0.51f);
            } else {
                glowparticle.setColor(0.43f, 0.77f, 0.62f);
            }
            glowparticle.setParticleSpeed(xSpeed * 0.01, ySpeed * 0.01, zSpeed * 0.01);
            int i = 10;
            int j = 40;
            glowparticle.setLifetime(level.random.nextInt(30) + 10);
            return glowparticle;
        }
    }

    public static class GlowSquidProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprite;

        public GlowSquidProvider(SpriteSet sprites) {
            this.sprite = sprites;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            AmethystGlowParticle glowparticle = new AmethystGlowParticle(level, x, y, z, 0.5 - RANDOM.nextDouble(), ySpeed, 0.5 - RANDOM.nextDouble(), this.sprite);
            if (level.random.nextBoolean()) {
                glowparticle.setColor(0.8f, 0.576f, 0.96f);
            } else {
                glowparticle.setColor(0.372f, 0.232f, 0.616f);
            }
            glowparticle.yd *= 0.2f;
            if (xSpeed == 0.0 && zSpeed == 0.0) {
                glowparticle.xd *= 0.1f;
                glowparticle.zd *= 0.1f;
            }
            glowparticle.setLifetime((int)(8.0 / (level.random.nextDouble() * 0.8 + 0.2)));
            return glowparticle;
        }
    }

    public static class ElectricSparkProvider
    implements ParticleProvider<SimpleParticleType> {
        private final double SPEED_FACTOR = 0.25;
        private final SpriteSet sprite;

        public ElectricSparkProvider(SpriteSet sprites) {
            this.sprite = sprites;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            AmethystGlowParticle glowparticle = new AmethystGlowParticle(level, x, y, z, 0.0, 0.0, 0.0, this.sprite);
            glowparticle.setColor(1.0f, 0.9f, 1.0f);
            glowparticle.setParticleSpeed(xSpeed * 0.25, ySpeed * 0.25, zSpeed * 0.25);
            int i = 2;
            int j = 4;
            glowparticle.setLifetime(level.random.nextInt(2) + 2);
            return glowparticle;
        }
    }
}

