/*
 * Decompiled with CFR 0.152.
 */
package net.carbonmc.graphene.util;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.util.Pool;
import net.minecraft.nbt.CompoundTag;

public class KryoContext {
    private static final Pool<Kryo> KRYO_POOL = new Pool<Kryo>(true, false, 16){

        protected Kryo create() {
            Kryo kryo = new Kryo();
            kryo.register(CompoundTag.class);
            kryo.setReferences(true);
            kryo.setRegistrationRequired(false);
            return kryo;
        }
    };
    private static final Pool<Output> OUTPUT_POOL = new Pool<Output>(true, false, 32){

        protected Output create() {
            return new Output(1024, -1);
        }
    };
    private static final Pool<Input> INPUT_POOL = new Pool<Input>(true, false, 32){

        protected Input create() {
            return new Input(1024);
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] serialize(CompoundTag tag) {
        Kryo kryo = (Kryo)KRYO_POOL.obtain();
        Output output = (Output)OUTPUT_POOL.obtain();
        try {
            output.reset();
            kryo.writeObject(output, (Object)tag);
            byte[] byArray = output.toBytes();
            return byArray;
        }
        finally {
            KRYO_POOL.free((Object)kryo);
            OUTPUT_POOL.free((Object)output);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CompoundTag deserialize(byte[] data) {
        if (data == null || data.length == 0) {
            return null;
        }
        Kryo kryo = (Kryo)KRYO_POOL.obtain();
        Input input = (Input)INPUT_POOL.obtain();
        try {
            input.setBuffer(data);
            CompoundTag compoundTag = (CompoundTag)kryo.readObject(input, CompoundTag.class);
            return compoundTag;
        }
        finally {
            KRYO_POOL.free((Object)kryo);
            INPUT_POOL.free((Object)input);
        }
    }
}

