/*
 * Decompiled with CFR 0.152.
 */
package net.carbonmc.graphene.particles;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.carbonmc.graphene.config.CoolConfig;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_3218;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AsyncParticleHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int MAX_PARTICLES_PER_TICK = 1000;
    private static volatile ExecutorService executorService;
    private static final BlockingQueue<ParticleTask> particleQueue;
    private static final ThreadLocal<class_2338.class_2339> mutablePosCache;

    public static void init() {
        if (((Boolean)CoolConfig.ASYNC_PARTICLES.get()).booleanValue()) {
            int threads = Math.max(1, Math.min((Integer)CoolConfig.maxthreads.get(), Runtime.getRuntime().availableProcessors()));
            executorService = new ThreadPoolExecutor(threads, threads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), r -> {
                Thread t = new Thread(r, "Async particle Worker");
                t.setDaemon(true);
                return t;
            });
            LOGGER.info("Async particle System initialized with {} threads", (Object)threads);
        }
    }

    public static void shutdown() {
        if (executorService != null) {
            ExecutorService es = executorService;
            executorService = null;
            es.shutdown();
            try {
                if (!es.awaitTermination(3L, TimeUnit.SECONDS)) {
                    es.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                es.shutdownNow();
                Thread.currentThread().interrupt();
            }
        }
    }

    public static void addParticle(class_1937 level, class_2394 particle, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        if (!((Boolean)CoolConfig.ASYNC_PARTICLES.get()).booleanValue() || level.field_9236) {
            level.method_8406(particle, x, y, z, xSpeed, ySpeed, zSpeed);
            return;
        }
        if (particleQueue.remainingCapacity() > 0) {
            particleQueue.offer(new ParticleTask(level, particle, x, y, z, xSpeed, ySpeed, zSpeed));
        }
    }

    public static void onServerTick() {
        AsyncParticleHandler.processParticles();
    }

    private static void processParticles() {
        ParticleTask task;
        for (int processed = 0; processed < 1000 && (task = (ParticleTask)particleQueue.poll()) != null; ++processed) {
            ParticleTask finalTask = task;
            executorService.execute(() -> {
                class_2338.class_2339 pos;
                class_3218 serverLevel = (class_3218)finalTask.level;
                if (serverLevel != null && serverLevel.method_8477((class_2338)(pos = mutablePosCache.get().method_10102(finalTask.x(), finalTask.y(), finalTask.z())))) {
                    serverLevel.method_65096(finalTask.particle(), finalTask.x(), finalTask.y(), finalTask.z(), 1, finalTask.xSpeed(), finalTask.ySpeed(), finalTask.zSpeed(), 1.0);
                }
            });
        }
    }

    static {
        particleQueue = new LinkedBlockingQueue<ParticleTask>();
        mutablePosCache = ThreadLocal.withInitial(class_2338.class_2339::new);
    }

    private record ParticleTask(class_1937 level, class_2394 particle, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
    }
}

