/*
 * Decompiled with CFR 0.152.
 */
package net.carbonmc.graphene.asm;

import java.util.function.Function;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class GrapheneCorePlugin
implements Function<ClassNode, ClassNode>,
Opcodes {
    @Override
    public ClassNode apply(ClassNode node) {
        if (!"net/minecraft/world/entity/projectile/Projectile".equals(node.name)) {
            return node;
        }
        for (MethodNode mn : node.methods) {
            if ("tick".equals(mn.name) && "()V".equals(mn.desc)) {
                this.patchTick(mn);
            }
            if (!"lerpMotion".equals(mn.name) || !"(DDD)V".equals(mn.desc)) continue;
            this.patchLerpMotion(mn);
        }
        return node;
    }

    private void patchTick(MethodNode mn) {
        for (AbstractInsnNode ain : mn.instructions) {
            FieldInsnNode fin;
            if (ain instanceof FieldInsnNode && (fin = (FieldInsnNode)ain).getOpcode() == 180 && fin.name.equals("lastRenderX")) {
                fin.name = "lastTrackedX";
                fin.desc = "D";
            }
            if (ain instanceof FieldInsnNode && (fin = (FieldInsnNode)ain).getOpcode() == 181 && fin.name.equals("lastRenderX")) {
                fin.name = "lastTrackedX";
                fin.desc = "D";
            }
            if (ain instanceof FieldInsnNode && (fin = (FieldInsnNode)ain).getOpcode() == 180 && fin.name.equals("lastRenderY")) {
                fin.name = "lastTrackedY";
            }
            if (ain instanceof FieldInsnNode && (fin = (FieldInsnNode)ain).getOpcode() == 181 && fin.name.equals("lastRenderY")) {
                fin.name = "lastTrackedY";
            }
            if (ain instanceof FieldInsnNode && (fin = (FieldInsnNode)ain).getOpcode() == 180 && fin.name.equals("lastRenderZ")) {
                fin.name = "lastTrackedZ";
            }
            if (!(ain instanceof FieldInsnNode) || (fin = (FieldInsnNode)ain).getOpcode() != 181 || !fin.name.equals("lastRenderZ")) continue;
            fin.name = "lastTrackedZ";
        }
    }

    private void patchLerpMotion(MethodNode mn) {
        for (AbstractInsnNode ain : mn.instructions) {
            FieldInsnNode fin;
            if (!(ain instanceof FieldInsnNode) || (fin = (FieldInsnNode)ain).getOpcode() != 180 || !fin.name.equals("lastRenderX") && !fin.name.equals("lastRenderY") && !fin.name.equals("lastRenderZ")) continue;
            fin.name = fin.name.replace("lastRender", "lastTracked");
        }
    }
}

