/*
 * Decompiled with CFR 0.152.
 */
package net.carbonmc.graphene.async.entity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import net.carbonmc.graphene.async.AsyncSystemInitializer;
import net.carbonmc.graphene.event.AsyncHandler;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@AsyncHandler(threadPool="compute", fallbackToSync=true)
public class AsyncCollisionSystem {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final BlockingQueue<CollisionTask> collisionQueue = new LinkedBlockingQueue<CollisionTask>(1000);
    private static final Map<UUID, CollisionTask> activeTasks = new ConcurrentHashMap<UUID, CollisionTask>();
    private static final int MAX_BATCH_SIZE = 50;
    private static final Semaphore processingSemaphore = new Semaphore(50);

    public static void init() {
        LOGGER.info("Async Collision System initialized");
    }

    public static void shutdown() {
        collisionQueue.clear();
        activeTasks.clear();
        LOGGER.info("Async Collision System shutdown");
    }

    public static void checkCollisionsAsync(Collection<Entity> entities) {
        if (entities.isEmpty()) {
            return;
        }
        if (!processingSemaphore.tryAcquire()) {
            LOGGER.warn("Too many collision tasks queued, skipping this batch");
            return;
        }
        CollisionTask task = new CollisionTask(new ArrayList<Entity>(entities));
        if (collisionQueue.offer(task)) {
            activeTasks.put(task.taskId(), task);
        } else {
            LOGGER.warn("Collision queue full, skipping task");
            processingSemaphore.release();
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            AsyncCollisionSystem.processCollisionTasks();
            AsyncCollisionSystem.applyCollisionResults();
        }
    }

    private static void processCollisionTasks() {
        int processed = 0;
        while (processed < 100 && !collisionQueue.isEmpty()) {
            CollisionTask task = (CollisionTask)collisionQueue.poll();
            if (task == null || !activeTasks.containsKey(task.taskId())) continue;
            AsyncSystemInitializer.getThreadPool("compute").execute(() -> {
                try {
                    ArrayList<CollisionResult> results = new ArrayList<CollisionResult>();
                    Entity[] entityArray = task.entities().toArray(new Entity[0]);
                    for (int j = 0; j < entityArray.length; ++j) {
                        Entity e1 = entityArray[j];
                        if (e1.m_213877_() || !e1.m_6084_()) continue;
                        for (int k = j + 1; k < entityArray.length; ++k) {
                            Entity e2 = entityArray[k];
                            if (e2.m_213877_() || !e2.m_6084_() || !e1.m_20191_().m_82381_(e2.m_20191_())) continue;
                            results.add(new CollisionResult(e1, e2));
                        }
                    }
                    task.results().addAll(results);
                    task.completed().set(true);
                }
                catch (Exception e) {
                    LOGGER.error("Collision detection failed", (Throwable)e);
                    task.error().set(e);
                }
                finally {
                    processingSemaphore.release();
                }
            });
            ++processed;
        }
    }

    private static void applyCollisionResults() {
        activeTasks.entrySet().removeIf(entry -> {
            CollisionTask task = (CollisionTask)entry.getValue();
            if (task.completed().get()) {
                if (task.error().get() == null) {
                    for (CollisionResult result : task.results()) {
                        if (result.entity1().m_213877_() || !result.entity1().m_6084_() || result.entity2().m_213877_() || !result.entity2().m_6084_()) continue;
                        result.entity1().m_7334_(result.entity2());
                        result.entity2().m_7334_(result.entity1());
                    }
                    LOGGER.debug("Applied {} collision results", (Object)task.results().size());
                }
                return true;
            }
            return false;
        });
    }

    private static class CollisionTask {
        private final UUID taskId = UUID.randomUUID();
        private final List<Entity> entities;
        private final List<CollisionResult> results = new CopyOnWriteArrayList<CollisionResult>();
        private final AtomicBoolean completed = new AtomicBoolean(false);
        private final AtomicReference<Exception> error = new AtomicReference();

        public CollisionTask(List<Entity> entities) {
            this.entities = Collections.unmodifiableList(entities);
        }

        public UUID taskId() {
            return this.taskId;
        }

        public List<Entity> entities() {
            return this.entities;
        }

        public List<CollisionResult> results() {
            return this.results;
        }

        public AtomicBoolean completed() {
            return this.completed;
        }

        public AtomicReference<Exception> error() {
            return this.error;
        }
    }

    private record CollisionResult(Entity entity1, Entity entity2) {
    }
}

