/*
 * Decompiled with CFR 0.152.
 */
package net.carbonmc.graphene.mixin.chunk;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.mojang.datafixers.util.Pair;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import net.carbonmc.graphene.config.CoolConfig;
import net.carbonmc.graphene.mixin.chunk.CellCountKey;
import net.carbonmc.graphene.mixin.chunk.CoordinateConversionKey;
import net.carbonmc.graphene.mixin.chunk.StructureLookupKey;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.placement.ConcentricRingsStructurePlacement;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ChunkGenerator.class})
public abstract class ChunkGeneratorMixin {
    @Unique
    private final Cache<StructureLookupKey, Pair<BlockPos, Holder<Structure>>> structureLookupCache = Caffeine.newBuilder().maximumSize(512L).expireAfterAccess(2L, TimeUnit.MINUTES).build();
    @Unique
    private final Cache<CoordinateConversionKey, BlockPos> coordinateConversionCache = Caffeine.newBuilder().maximumSize(1024L).expireAfterAccess(5L, TimeUnit.MINUTES).build();
    @Unique
    private final Cache<CellCountKey, Integer> cellCountCache = Caffeine.newBuilder().maximumSize(256L).expireAfterAccess(5L, TimeUnit.MINUTES).build();

    @Inject(method={"findNearestMapStructure"}, at={@At(value="HEAD")}, cancellable=true)
    public void onFindNearestMapStructure(ServerLevel level, HolderSet<Structure> structures, BlockPos pos, int radius, boolean skipExisting, CallbackInfoReturnable<Pair<BlockPos, Holder<Structure>>> cir) {
        if (!((Boolean)CoolConfig.XtackChunk_BETA.get()).booleanValue()) {
            return;
        }
        int structuresHash = this.computeStructuresHash(structures);
        StructureLookupKey cacheKey = new StructureLookupKey(level.m_7328_(), structuresHash, pos, radius, skipExisting);
        Pair cachedResult = (Pair)this.structureLookupCache.getIfPresent((Object)cacheKey);
        if (cachedResult != null) {
            cir.setReturnValue((Object)cachedResult);
            cir.cancel();
        }
    }

    @Inject(method={"findNearestMapStructure"}, at={@At(value="RETURN")})
    public void onFindNearestMapStructureReturn(ServerLevel level, HolderSet<Structure> structures, BlockPos pos, int radius, boolean skipExisting, CallbackInfoReturnable<Pair<BlockPos, Holder<Structure>>> cir) {
        if (!((Boolean)CoolConfig.XtackChunk_BETA.get()).booleanValue()) {
            return;
        }
        Pair result = (Pair)cir.getReturnValue();
        if (result != null) {
            int structuresHash = this.computeStructuresHash(structures);
            StructureLookupKey cacheKey = new StructureLookupKey(level.m_7328_(), structuresHash, pos, radius, skipExisting);
            this.structureLookupCache.put((Object)cacheKey, (Object)result);
        }
    }

    @Inject(method={"getNearestGeneratedStructure"}, at={@At(value="HEAD")}, cancellable=true)
    private void onGetNearestGeneratedStructure(Set<Holder<Structure>> structures, ServerLevel level, StructureManager structureManager, BlockPos pos, boolean skipExisting, ConcentricRingsStructurePlacement placement, CallbackInfoReturnable<Pair<BlockPos, Holder<Structure>>> cir) {
        if (!((Boolean)CoolConfig.XtackChunk_BETA.get()).booleanValue()) {
            return;
        }
        StructureLookupKey cacheKey = new StructureLookupKey(level.m_7328_(), structures.hashCode(), pos, placement != null ? placement.hashCode() : 0, skipExisting);
        Pair cachedResult = (Pair)this.structureLookupCache.getIfPresent((Object)cacheKey);
        if (cachedResult != null) {
            cir.setReturnValue((Object)cachedResult);
            cir.cancel();
        }
    }

    @Inject(method={"getNearestGeneratedStructure"}, at={@At(value="RETURN")})
    private void onGetNearestGeneratedStructureReturn(Set<Holder<Structure>> structures, ServerLevel level, StructureManager structureManager, BlockPos pos, boolean skipExisting, ConcentricRingsStructurePlacement placement, CallbackInfoReturnable<Pair<BlockPos, Holder<Structure>>> cir) {
        if (!((Boolean)CoolConfig.XtackChunk_BETA.get()).booleanValue()) {
            return;
        }
        Pair result = (Pair)cir.getReturnValue();
        if (result != null) {
            StructureLookupKey cacheKey = new StructureLookupKey(level.m_7328_(), structures.hashCode(), pos, placement != null ? placement.hashCode() : 0, skipExisting);
            this.structureLookupCache.put((Object)cacheKey, (Object)result);
        }
    }

    @Unique
    private int computeStructuresHash(HolderSet<Structure> structures) {
        return structures.hashCode();
    }

    @Unique
    public BlockPos getCachedCoordinateConversion(long seed, int x, int z, int conversionType) {
        if (!((Boolean)CoolConfig.XtackChunk_BETA.get()).booleanValue()) {
            return null;
        }
        CoordinateConversionKey key = new CoordinateConversionKey(seed, x, z, conversionType);
        return (BlockPos)this.coordinateConversionCache.getIfPresent((Object)key);
    }

    @Unique
    public void cacheCoordinateConversion(long seed, int x, int z, int conversionType, BlockPos result) {
        if (!((Boolean)CoolConfig.XtackChunk_BETA.get()).booleanValue()) {
            return;
        }
        CoordinateConversionKey key = new CoordinateConversionKey(seed, x, z, conversionType);
        this.coordinateConversionCache.put((Object)key, (Object)result);
    }

    @Unique
    public Integer getCachedCellCount(long seed, int cellX, int cellZ, boolean isHorizontal) {
        if (!((Boolean)CoolConfig.XtackChunk_BETA.get()).booleanValue()) {
            return null;
        }
        CellCountKey key = new CellCountKey(seed, cellX, cellZ, isHorizontal);
        return (Integer)this.cellCountCache.getIfPresent((Object)key);
    }

    @Unique
    public void cacheCellCount(long seed, int cellX, int cellZ, boolean isHorizontal, int count) {
        if (!((Boolean)CoolConfig.XtackChunk_BETA.get()).booleanValue()) {
            return;
        }
        CellCountKey key = new CellCountKey(seed, cellX, cellZ, isHorizontal);
        this.cellCountCache.put((Object)key, (Object)count);
    }
}

