/*
 * Decompiled with CFR 0.152.
 */
package net.carbonmc.graphene.mixin.chunk;

import net.minecraft.core.BlockPos;

class StructureLookupKey {
    private final long seed;
    private final int structuresHash;
    private final BlockPos pos;
    private final int additionalParam;
    private final boolean skipExisting;
    private final int hashCode;

    public StructureLookupKey(long seed, int structuresHash, BlockPos pos, int additionalParam, boolean skipExisting) {
        this.seed = seed;
        this.structuresHash = structuresHash;
        this.pos = pos;
        this.additionalParam = additionalParam;
        this.skipExisting = skipExisting;
        this.hashCode = this.computeHashCode();
    }

    private int computeHashCode() {
        int result = (int)(this.seed ^ this.seed >>> 32);
        result = 31 * result + this.structuresHash;
        result = 31 * result + (this.pos != null ? this.pos.hashCode() : 0);
        result = 31 * result + this.additionalParam;
        result = 31 * result + (this.skipExisting ? 1 : 0);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StructureLookupKey that = (StructureLookupKey)o;
        return this.seed == that.seed && this.structuresHash == that.structuresHash && this.additionalParam == that.additionalParam && this.skipExisting == that.skipExisting && (this.pos != null ? this.pos.equals((Object)that.pos) : that.pos == null);
    }

    public int hashCode() {
        return this.hashCode;
    }
}

