/*
 * Decompiled with CFR 0.152.
 */
package net.carbonmc.graphene.TickHelper;

import com.google.common.collect.ImmutableSet;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import net.carbonmc.graphene.api.IOptimizableEntity;
import net.carbonmc.graphene.config.CoolConfig;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.BossEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.Item;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber
public final class EntityTickHelper {
    private static final AtomicReference<Set<EntityType<?>>> ENTITY_WHITELIST = new AtomicReference(Collections.emptySet());
    private static final AtomicReference<Set<Item>> ITEM_WHITELIST = new AtomicReference(Collections.emptySet());
    private static final ExecutorService TICK_EXECUTOR = Executors.newWorkStealingPool();
    private static volatile boolean optimizeEntitiesEnabled = true;

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            EntityTickHelper.updateConfigCache();
        }
    }

    private static void updateConfigCache() {
        optimizeEntitiesEnabled = (Boolean)CoolConfig.optimizeEntities.get();
    }

    public static void refreshWhitelists() {
        CompletableFuture.runAsync(() -> {
            ENTITY_WHITELIST.set((Set<EntityType<?>>)ImmutableSet.copyOf((Collection)((List)CoolConfig.entityWhitelist.get()).stream().map(s -> (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(s))).filter(Objects::nonNull).collect(Collectors.toSet())));
            ITEM_WHITELIST.set((Set<Item>)ImmutableSet.copyOf((Collection)((List)CoolConfig.itemWhitelist.get()).stream().map(s -> (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(s))).filter(Objects::nonNull).collect(Collectors.toSet())));
        }, TICK_EXECUTOR);
    }

    public static boolean shouldCancelTick(@NotNull Entity entity) {
        IOptimizableEntity opt;
        Field[] living;
        boolean result = optimizeEntitiesEnabled;
        if (entity instanceof Player || ENTITY_WHITELIST.get().contains(entity.m_6095_()) || entity instanceof Raider) {
            result = false;
        }
        if (((IOptimizableEntity)entity.m_6095_()).graphene$shouldAlwaysTick()) {
            result = false;
        }
        if (!(entity instanceof LivingEntity) || !(living = (Field[])entity).m_6084_()) {
            result = false;
        }
        if (entity.getClass().getSimpleName().toLowerCase().contains("boss") || entity.getClass().getSimpleName().toLowerCase().contains("dragon") || entity.getClass().getSimpleName().toLowerCase().contains("wither") && !entity.getClass().getSimpleName().toLowerCase().contains("skeleton")) {
            result = false;
            ((IOptimizableEntity)entity.m_6095_()).graphene$setAlwaysTick(true);
        }
        for (Field declaredField : entity.getClass().getDeclaredFields()) {
            if (!BossEvent.class.isAssignableFrom(declaredField.getType())) continue;
            ((IOptimizableEntity)entity.m_6095_()).graphene$setAlwaysTick(true);
            result = false;
            break;
        }
        if (entity instanceof IOptimizableEntity && (opt = (IOptimizableEntity)entity).graphene$shouldAlwaysTick()) {
            return false;
        }
        return result;
    }

    static {
        EntityTickHelper.refreshWhitelists();
        EntityTickHelper.updateConfigCache();
    }
}

