/*
 * Decompiled with CFR 0.152.
 */
package net.carbonmc.graphene.async.chunk;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import net.carbonmc.graphene.config.CoolConfig;
import org.jetbrains.annotations.NotNull;

public final class Executor
extends ThreadPoolExecutor {
    private final LongAdder submittedTaskCounter = new LongAdder();
    private final LongAdder completedTaskCounter = new LongAdder();
    private final AtomicLong lastTaskTimestamp = new AtomicLong();
    private final String name;

    public Executor(int corePoolSize, int maximumQueueCapacity, String threadNamePrefix) {
        super(corePoolSize, corePoolSize, 30L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(Math.max(16, maximumQueueCapacity), false), new ThreadFactoryImpl(threadNamePrefix), new AdaptiveRejectionPolicy());
        this.name = threadNamePrefix;
        this.allowCoreThreadTimeOut(true);
        this.prestartAllCoreThreads();
    }

    @Override
    public void execute(@NotNull Runnable command) {
        if (!((Boolean)CoolConfig.CTU.get()).booleanValue()) {
            command.run();
            return;
        }
        this.submittedTaskCounter.increment();
        this.lastTaskTimestamp.set(System.nanoTime());
        super.execute(command);
    }

    @Override
    protected void beforeExecute(Thread t, Runnable r) {
        if (((Boolean)CoolConfig.CTU.get()).booleanValue()) {
            t.setContextClassLoader(this.getClass().getClassLoader());
            t.setPriority(6);
        }
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        this.completedTaskCounter.increment();
        if (t != null) {
            // empty if block
        }
    }

    public int getQueueSize() {
        return this.getQueue().size();
    }

    public long getSubmittedCount() {
        return this.submittedTaskCounter.sum();
    }

    public long getCompletedCount() {
        return this.completedTaskCounter.sum();
    }

    public double getLoadFactor() {
        long completed = this.completedTaskCounter.sum();
        long submitted = this.submittedTaskCounter.sum();
        return submitted == 0L ? 0.0 : (double)completed / (double)submitted;
    }

    private static final class ThreadFactoryImpl
    implements ThreadFactory {
        private final ThreadFactory defaultFactory = Executors.defaultThreadFactory();
        private final String namePrefix;
        private final AtomicLong threadCounter = new AtomicLong(0L);

        ThreadFactoryImpl(String prefix) {
            this.namePrefix = prefix != null ? prefix : "Graphene-Worker";
        }

        @Override
        public Thread newThread(@NotNull Runnable runnable) {
            Thread thread = this.defaultFactory.newThread(runnable);
            thread.setName(this.namePrefix + "-" + this.threadCounter.incrementAndGet());
            thread.setDaemon(true);
            thread.setPriority(5);
            thread.setUncaughtExceptionHandler((t, e) -> {});
            return thread;
        }
    }

    private static final class AdaptiveRejectionPolicy
    implements RejectedExecutionHandler {
        private final RejectedExecutionHandler fallback = new ThreadPoolExecutor.CallerRunsPolicy();

        private AdaptiveRejectionPolicy() {
        }

        @Override
        public void rejectedExecution(Runnable runnable, ThreadPoolExecutor executor) {
            if (executor.isShutdown()) {
                throw new RejectedExecutionException("Executor has been shutdown");
            }
            if (executor.getQueue().size() > 1000) {
                return;
            }
            this.fallback.rejectedExecution(runnable, executor);
        }
    }
}

