/*
 * Decompiled with CFR 0.152.
 */
package net.carbonmc.graphene.client.resources;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3304;
import net.minecraft.class_4013;
import org.jetbrains.annotations.Nullable;

public class ResourceManager
implements class_4013 {
    private static final int MAX_CACHED_RESOURCES = 1000;
    private static final Cache<String, byte[]> resourceCache = Caffeine.newBuilder().maximumSize(1000L).build();

    public static void onRegisterReloadListeners(class_3304 manager) {
        manager.method_14477((class_3302)new ResourceManager());
    }

    public void method_14491(class_3300 resourceManager) {
        resourceCache.invalidateAll();
    }

    @Nullable
    public static byte[] getCompressedResource(String path) {
        Objects.requireNonNull(path, "Resource path cannot be null");
        if (path.isEmpty()) {
            throw new IllegalArgumentException("Resource path cannot be empty");
        }
        return (byte[])resourceCache.get((Object)path, k -> {
            byte[] byArray;
            block9: {
                InputStream input = ResourceManager.class.getResourceAsStream(path);
                try {
                    if (input == null) {
                        throw new IOException("Resource not found: " + path);
                    }
                    byArray = input.readAllBytes();
                    if (input == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (input != null) {
                            try {
                                input.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Failed to load resource: " + path, e);
                    }
                }
                input.close();
            }
            return byArray;
        });
    }
}

