/*
 * Decompiled with CFR 0.152.
 */
package net.carbonmc.graphene.engine.cull;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_2680;

public final class AsyncTracer {
    private static final AtomicInteger THREAD_COUNTER = new AtomicInteger();
    private static final ExecutorService TRACER_POOL = Executors.newFixedThreadPool(Math.max(2, Runtime.getRuntime().availableProcessors() / 2), r -> new Thread(r, "AsyncTracer-" + THREAD_COUNTER.incrementAndGet()));
    private static final Cache<Long, Boolean> TRACE_CACHE = Caffeine.newBuilder().maximumSize(10000L).expireAfterWrite(500L, TimeUnit.MILLISECONDS).build();

    public static CompletableFuture<Boolean> traceAsync(class_243 start, class_243 end, class_1922 level) {
        long cacheKey = AsyncTracer.computeTraceHash(start, end);
        Boolean cached = (Boolean)TRACE_CACHE.getIfPresent((Object)cacheKey);
        if (cached != null) {
            return CompletableFuture.completedFuture(cached);
        }
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        TRACER_POOL.execute(() -> {
            try {
                boolean result = AsyncTracer.traceVisibility(start, end, level);
                TRACE_CACHE.put((Object)cacheKey, (Object)result);
                future.complete(result);
            }
            catch (Exception e) {
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    private static long computeTraceHash(class_243 start, class_243 end) {
        return (long)Float.floatToIntBits((float)start.field_1352) << 48 | (long)Float.floatToIntBits((float)start.field_1351) << 32 | (long)Float.floatToIntBits((float)start.field_1350) << 16 | (long)Float.floatToIntBits((float)end.field_1352) << 12 | (long)Float.floatToIntBits((float)end.field_1351) << 8 | (long)Float.floatToIntBits((float)end.field_1350);
    }

    private static boolean traceVisibility(class_243 start, class_243 end, class_1922 level) {
        class_243 dir = end.method_1020(start);
        double dist = dir.method_1033();
        if (dist < 0.001) {
            return true;
        }
        dir = dir.method_1029();
        double step = Math.min(0.25, dist / 20.0);
        class_243 current = start;
        class_2338.class_2339 mpos = new class_2338.class_2339();
        while (current.method_1022(start) < dist) {
            class_265 shape;
            mpos.method_10102(current.field_1352, current.field_1351, current.field_1350);
            class_2680 state = level.method_8320((class_2338)mpos);
            if (!state.method_26215() && !(shape = state.method_26220(level, (class_2338)mpos)).method_1110() && shape.method_1107().method_996((class_2338)mpos).method_1006(current)) {
                return false;
            }
            current = current.method_1019(dir.method_1021(step));
        }
        return true;
    }

    public static void shutdown() {
        TRACER_POOL.shutdownNow();
    }
}

