/*
 * Decompiled with CFR 0.152.
 */
package net.carbonmc.graphene.mixin.client.renderer.reflex;

import net.carbonmc.graphene.config.CoolConfig;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_4599;
import net.minecraft.class_757;
import net.minecraft.class_759;
import net.minecraft.class_9779;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL33;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_757.class})
public abstract class ReflexSchedulerMixin {
    private static final int MODE_DISABLED = 0;
    private static final int MODE_TIMESTAMP = 1;
    private static final int MODE_ELAPSED = 2;
    @Shadow
    @Final
    private class_310 field_4015;
    private static final Logger LOGGER = LogManager.getLogger((String)"Graphene-Reflex");
    private static final long MAX_WAIT_NS = 2000000L;
    private static final long MIN_FRAME_NS = 1000000L;
    private static final double SMOOTH_ALPHA = 0.15;
    private int timingMode = 0;
    private final int[] queryIds = new int[2];
    private int queryIndex = 0;
    private long lastGpuDoneNs = -1L;
    private long lastFrameEndNs = -1L;
    private double smoothedDeltaNs = 0.0;

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void reflex$init(class_310 p_234219_, class_759 p_234220_, class_3300 p_234221_, class_4599 p_234222_, CallbackInfo ci) {
        if (GL.getCapabilities().GL_ARB_timer_query) {
            this.timingMode = 1;
            GL33.glGenQueries((int[])this.queryIds);
            LOGGER.info("Using high-precision timestamp queries");
        } else if (GL.getCapabilities().GL_EXT_timer_query || GL.getCapabilities().GL_ARB_occlusion_query) {
            this.timingMode = 2;
            GL33.glGenQueries((int[])this.queryIds);
            LOGGER.info("Using elapsed time queries (compatibility mode)");
        } else {
            LOGGER.warn("No supported GPU timing method available, Reflex disabled");
        }
    }

    @Inject(method={"render"}, at={@At(value="HEAD")})
    private void reflex$onCpuStart(class_9779 pDeltaTracker, boolean pRenderLevel, CallbackInfo ci) {
        long elapsed;
        long targetFrameTime;
        long remaining;
        int maxFps;
        if (!(CoolConfig.SPEC.isLoaded() ? (Boolean)CoolConfig.enableReflex.get() : (Boolean)CoolConfig.enableReflex.getDefault()).booleanValue() || this.timingMode == 0) {
            return;
        }
        long cpuNow = System.nanoTime();
        long gpuDone = -1L;
        switch (this.timingMode) {
            case 1: {
                gpuDone = this.getGpuTimestamp(cpuNow);
                break;
            }
            case 2: {
                gpuDone = this.getGpuElapsedTime(cpuNow);
            }
        }
        if (gpuDone > 0L && gpuDone < cpuNow) {
            this.lastGpuDoneNs = gpuDone;
            long cpuElapsed = cpuNow - this.lastGpuDoneNs;
            this.smoothedDeltaNs = 0.15 * (double)cpuElapsed + 0.85 * this.smoothedDeltaNs;
            long waitNs = (long)(this.smoothedDeltaNs + (double)(CoolConfig.SPEC.isLoaded() ? (Long)CoolConfig.reflexOffsetNs.get() : (Long)CoolConfig.reflexOffsetNs.getDefault()).longValue());
            if ((waitNs = Math.max(-2000000L, Math.min(2000000L, waitNs))) > 0L) {
                this.smartWait(cpuNow, waitNs);
            }
        }
        if ((maxFps = (CoolConfig.SPEC.isLoaded() ? (Integer)CoolConfig.MAX_FPS.get() : (Integer)CoolConfig.MAX_FPS.getDefault()).intValue()) > 0 && this.lastFrameEndNs > 0L && (remaining = (targetFrameTime = 1000000000L / (long)maxFps) - (elapsed = cpuNow - this.lastFrameEndNs)) > 1000000L) {
            this.smartWait(cpuNow, remaining);
        }
        if ((CoolConfig.SPEC.isLoaded() ? (Boolean)CoolConfig.reflexDebug.get() : (Boolean)CoolConfig.reflexDebug.getDefault()).booleanValue()) {
            LOGGER.debug("Reflex stats - Mode: {}, GPU: {}ns, CPU: {}ns, Delta: {}ns", (Object)this.timingModeToString(), (Object)this.lastGpuDoneNs, (Object)this.lastFrameEndNs, (Object)this.smoothedDeltaNs);
        }
    }

    @Inject(method={"render"}, at={@At(value="RETURN")})
    private void reflex$onCpuEnd(class_9779 pDeltaTracker, boolean pRenderLevel, CallbackInfo ci) {
        if (this.timingMode == 0 || !(CoolConfig.SPEC.isLoaded() ? (Boolean)CoolConfig.enableReflex.get() : (Boolean)CoolConfig.enableReflex.getDefault()).booleanValue()) {
            return;
        }
        switch (this.timingMode) {
            case 1: {
                GL33.glQueryCounter((int)this.queryIds[this.queryIndex], (int)36392);
                break;
            }
            case 2: {
                GL33.glBeginQuery((int)35007, (int)this.queryIds[this.queryIndex]);
                GL33.glEndQuery((int)35007);
            }
        }
        this.queryIndex ^= 1;
        this.lastFrameEndNs = System.nanoTime();
    }

    private long getGpuTimestamp(long cpuNow) {
        int prev = this.queryIndex ^ 1;
        if (!GL33.glIsQuery((int)this.queryIds[prev])) {
            return -1L;
        }
        int[] ready = new int[]{0};
        GL33.glGetQueryObjectiv((int)this.queryIds[prev], (int)34919, (int[])ready);
        if (ready[0] == 0) {
            return -1L;
        }
        long gpuTime = GL33.glGetQueryObjecti64((int)this.queryIds[prev], (int)34918);
        return gpuTime > 0L && gpuTime < cpuNow ? gpuTime : -1L;
    }

    private long getGpuElapsedTime(long cpuNow) {
        int prev = this.queryIndex ^ 1;
        if (!GL33.glIsQuery((int)this.queryIds[prev])) {
            return -1L;
        }
        int[] ready = new int[]{0};
        GL33.glGetQueryObjectiv((int)this.queryIds[prev], (int)34919, (int[])ready);
        if (ready[0] == 0) {
            return -1L;
        }
        int[] timeNs = new int[]{0};
        GL33.glGetQueryObjectiv((int)this.queryIds[prev], (int)34918, (int[])timeNs);
        return this.lastFrameEndNs > 0L ? this.lastFrameEndNs + (long)timeNs[0] * 1000000L : -1L;
    }

    private void smartWait(long startTime, long waitNs) {
        long currentTime;
        long endTime = startTime + waitNs;
        while ((currentTime = System.nanoTime()) < endTime - 100000L) {
            Thread.onSpinWait();
        }
        while (System.nanoTime() < endTime) {
            try {
                Thread.sleep(0L, 1000);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
        }
    }

    private String timingModeToString() {
        switch (this.timingMode) {
            case 1: {
                return "TIMESTAMP";
            }
            case 2: {
                return "ELAPSED";
            }
        }
        return "DISABLED";
    }
}

