/*
 * Decompiled with CFR 0.152.
 */
package net.carbonmc.graphene.engine.cull;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import net.carbonmc.graphene.config.CoolConfig;
import net.carbonmc.graphene.engine.cull.AsyncTracer;
import net.carbonmc.graphene.engine.cull.LeafOptiEngine;
import net.minecraft.class_1297;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_310;

public final class RenderOptimizer {
    private static final AtomicBoolean INITIALIZED = new AtomicBoolean(false);
    private static final AtomicBoolean FALLBACK_MODE = new AtomicBoolean(false);
    private static ExecutorService tracerPool;
    private static ScheduledExecutorService timeoutChecker;
    private static ScheduledExecutorService cacheCleaner;
    private static final Cache<Integer, Boolean> ENTITY_CACHE;
    private static final Cache<Long, Boolean> BLOCK_CACHE;

    public static void initialize() {
        if (INITIALIZED.getAndSet(true)) {
            return;
        }
        int threads = Math.max(1, (Integer)CoolConfig.tracingThreads.get());
        tracerPool = Executors.newWorkStealingPool(threads);
        timeoutChecker = Executors.newSingleThreadScheduledExecutor();
        cacheCleaner = Executors.newSingleThreadScheduledExecutor();
        cacheCleaner.scheduleAtFixedRate(() -> {
            if (FALLBACK_MODE.get() && System.currentTimeMillis() % 60000L < 100L) {
                FALLBACK_MODE.set(false);
            }
        }, 1L, 1L, TimeUnit.SECONDS);
    }

    public static void shutdown() {
        if (tracerPool != null) {
            tracerPool.shutdownNow();
        }
        if (timeoutChecker != null) {
            timeoutChecker.shutdownNow();
        }
        if (cacheCleaner != null) {
            cacheCleaner.shutdownNow();
        }
    }

    public static boolean shouldSkipEntity(class_1297 entity) {
        if (!((Boolean)CoolConfig.useAsyncTracing.get()).booleanValue()) {
            return false;
        }
        if (FALLBACK_MODE.get()) {
            return RenderOptimizer.fallbackEntityCheck(entity);
        }
        int entityId = entity.method_5628();
        Boolean cached = (Boolean)ENTITY_CACHE.getIfPresent((Object)entityId);
        if (cached != null) {
            return cached;
        }
        class_243 eyePos = RenderOptimizer.getCameraPosition();
        class_243 targetPos = entity.method_5829().method_1005();
        boolean result = (Boolean)((CompletableFuture)AsyncTracer.traceAsync(eyePos, targetPos, (class_1922)entity.method_37908()).exceptionally(e -> {
            FALLBACK_MODE.set(true);
            return RenderOptimizer.fallbackEntityCheck(entity);
        })).join();
        ENTITY_CACHE.put((Object)entityId, (Object)result);
        return result;
    }

    public static boolean shouldCullBlockFace(class_1922 level, class_2338 pos, class_2350 face) {
        if (!((Boolean)CoolConfig.useAsyncTracing.get()).booleanValue()) {
            return false;
        }
        if (FALLBACK_MODE.get()) {
            return LeafOptiEngine.checkSimpleConnection(level, pos.method_10093(face), face);
        }
        class_243 start = RenderOptimizer.getFaceCenter(pos, face);
        class_243 end = start.method_1019(new class_243((double)face.method_10148() * (Double)CoolConfig.traceDistance.get(), (double)face.method_10164() * (Double)CoolConfig.traceDistance.get(), (double)face.method_10165() * (Double)CoolConfig.traceDistance.get()));
        long posKey = pos.method_10063();
        Boolean cached = (Boolean)BLOCK_CACHE.getIfPresent((Object)posKey);
        if (cached != null) {
            return cached;
        }
        try {
            boolean result = ((CompletableFuture)RenderOptimizer.traceAsync(start, end, level).exceptionally(e -> {
                FALLBACK_MODE.set(true);
                return LeafOptiEngine.checkSimpleConnection(level, pos.method_10093(face));
            })).getNow(false);
            BLOCK_CACHE.put((Object)posKey, (Object)result);
            return result;
        }
        catch (Exception e2) {
            FALLBACK_MODE.set(true);
            return LeafOptiEngine.checkSimpleConnection(level, pos.method_10093(face), face);
        }
    }

    private static CompletableFuture<Boolean> traceAsync(class_243 start, class_243 end, class_1922 level) {
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        Future<?> task = tracerPool.submit(() -> {
            try {
                if (Thread.interrupted()) {
                    return;
                }
                future.complete(RenderOptimizer.traceVisibility(start, end, level));
            }
            catch (Exception e) {
                future.completeExceptionally(e);
            }
        });
        timeoutChecker.schedule(() -> {
            if (!future.isDone()) {
                task.cancel(true);
                future.complete(false);
            }
        }, 1L, TimeUnit.MINUTES);
        return future;
    }

    private static boolean traceVisibility(class_243 start, class_243 end, class_1922 level) {
        class_243 direction = end.method_1020(start);
        double distance = direction.method_1033();
        if (distance < 0.001) {
            return true;
        }
        direction = direction.method_1029();
        double stepSize = Math.min(0.5, distance / 8.0);
        class_2338.class_2339 mpos = new class_2338.class_2339();
        class_243 current = start;
        while (current.method_1022(start) < distance) {
            if (Thread.interrupted()) {
                return false;
            }
            mpos.method_10102(current.field_1352, current.field_1351, current.field_1350);
            class_2680 state = level.method_8320((class_2338)mpos);
            if (!state.method_26215() && state.method_26220(level, (class_2338)mpos).method_1107().method_996((class_2338)mpos).method_1006(current)) {
                return false;
            }
            current = current.method_1019(direction.method_1021(stepSize));
        }
        return true;
    }

    private static boolean fallbackEntityCheck(class_1297 entity) {
        double dist = RenderOptimizer.getCameraPosition().method_1022(entity.method_19538());
        return dist > (Double)CoolConfig.fallbackDistance.get();
    }

    private static class_243 getCameraPosition() {
        return class_310.method_1551().field_1773.method_19418().method_19326();
    }

    private static class_243 getFaceCenter(class_2338 pos, class_2350 face) {
        return new class_243((double)pos.method_10263() + 0.5 + (double)face.method_10148() * 0.501, (double)pos.method_10264() + 0.5 + (double)face.method_10164() * 0.501, (double)pos.method_10260() + 0.5 + (double)face.method_10165() * 0.501);
    }

    public static boolean isInFallbackMode() {
        return FALLBACK_MODE.get();
    }

    static {
        ENTITY_CACHE = Caffeine.newBuilder().maximumSize(1000L).expireAfterWrite(500L, TimeUnit.MILLISECONDS).build();
        BLOCK_CACHE = Caffeine.newBuilder().maximumSize(10000L).expireAfterWrite(1L, TimeUnit.SECONDS).build();
    }

    private static class CachedResult {
        final CompletableFuture<Boolean> future;
        final long timestamp = System.currentTimeMillis();

        CachedResult(CompletableFuture<Boolean> future) {
            this.future = future;
        }
    }
}

