/*
 * Decompiled with CFR 0.152.
 */
package net.carbonmc.graphene.mixin.client.chest;

import net.carbonmc.graphene.config.CoolConfig;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2586;
import net.minecraft.class_2595;
import net.minecraft.class_2611;
import net.minecraft.class_824;
import net.minecraft.class_827;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_824.class})
public abstract class OptimizedChestRenderer {
    private class_2338 lastPlayerPos;
    private long lastCheckTime;

    @Inject(method={"getRenderer"}, at={@At(value="HEAD")}, cancellable=true)
    private <E extends class_2586> void handleRendering(E entity, CallbackInfoReturnable<class_827<E>> cir) {
        if (!this.shouldOptimizeRendering(entity)) {
            return;
        }
        try {
            class_2338 pos = entity.method_11016();
            class_1937 level = entity.method_10997();
            if (!this.isValidPosition(level, pos)) {
                this.logDebug("\u65e0\u6548\u7684\u7bb1\u5b50\u4f4d\u7f6e\u6216\u4e16\u754c: " + String.valueOf(pos));
                return;
            }
            if (!this.shouldRenderChest(level, pos)) {
                cir.setReturnValue(null);
            }
        }
        catch (Exception e) {
            this.logDebug("\u4f18\u5316\u7bb1\u5b50\u6e32\u67d3\u65f6\u51fa\u9519: " + e.getMessage());
        }
    }

    private <E extends class_2586> boolean shouldOptimizeRendering(E entity) {
        return (Boolean)CoolConfig.ENABLE_OPTIMIZATION.get() != false && entity != null && !entity.method_11015() && entity.method_10997() != null && (entity instanceof class_2595 || entity instanceof class_2611 && (Boolean)CoolConfig.OPTIMIZE_ENDER_CHESTS.get() != false);
    }

    private boolean isValidPosition(class_1937 level, class_2338 pos) {
        return level != null && pos != null;
    }

    private boolean shouldRenderChest(class_1937 level, class_2338 chestPos) {
        class_2338 playerPos = this.getCachedPlayerPosition(level, chestPos);
        if (playerPos == null) {
            return false;
        }
        return !this.isBeyondRenderDistance(chestPos, playerPos);
    }

    private class_2338 getCachedPlayerPosition(class_1937 level, class_2338 chestPos) {
        long currentTime = System.currentTimeMillis();
        if (this.lastPlayerPos == null || currentTime - this.lastCheckTime > 500L) {
            class_1657 player = this.getNearestPlayerSafely(level, chestPos);
            this.lastPlayerPos = player != null ? player.method_24515() : null;
            this.lastCheckTime = currentTime;
        }
        return this.lastPlayerPos;
    }

    private class_1657 getNearestPlayerSafely(class_1937 level, class_2338 pos) {
        try {
            return level.method_18459((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), (double)((Integer)CoolConfig.MAX_RENDER_DISTANCE.get() * 16), false);
        }
        catch (Exception e) {
            this.logDebug("\u83b7\u53d6\u6700\u8fd1\u73a9\u5bb6\u5931\u8d25: " + e.getMessage());
            return null;
        }
    }

    private boolean isBeyondRenderDistance(class_2338 chestPos, class_2338 playerPos) {
        boolean beyond;
        double maxDistance = (Integer)CoolConfig.MAX_RENDER_DISTANCE.get() * 16;
        double distanceSq = chestPos.method_10262((class_2382)playerPos);
        boolean bl = beyond = distanceSq > maxDistance * maxDistance;
        if (beyond) {
            this.logDebug("\u8df3\u8fc7\u8fdc\u5904\u7bb1\u5b50: " + String.valueOf(chestPos) + " \u8ddd\u79bb: " + Math.sqrt(distanceSq));
        }
        return beyond;
    }

    private void logDebug(String message) {
        if (((Boolean)CoolConfig.DEBUG_LOGGING.get()).booleanValue()) {
            System.out.println("[Graphene] " + message);
        }
    }
}

