/*
 * Decompiled with CFR 0.152.
 */
package net.carbonmc.graphene.mixin.server;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_3233;
import net.minecraft.class_3610;
import net.minecraft.class_4076;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3233.class})
public abstract class MixinWorldGenRegion {
    @Shadow
    private List<class_2791> field_14098;
    @Shadow
    private int field_14088;
    @Shadow
    private class_1923 field_23788;
    @Shadow
    private class_1923 field_23789;
    private Cache<Long, class_2791> chunkCache;

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void onInit(CallbackInfo ci) {
        this.chunkCache = Caffeine.newBuilder().maximumSize(256L).expireAfterAccess(5L, TimeUnit.MINUTES).build();
    }

    @Overwrite
    public class_2791 method_8392(int chunkX, int chunkZ) {
        long key = (long)chunkX << 32 | (long)chunkZ & 0xFFFFFFFFL;
        class_2791 cachedChunk = (class_2791)this.chunkCache.getIfPresent((Object)key);
        if (cachedChunk != null) {
            return cachedChunk;
        }
        if (chunkX < this.field_23788.field_9181 || chunkX > this.field_23789.field_9181 || chunkZ < this.field_23788.field_9180 || chunkZ > this.field_23789.field_9180) {
            throw new RuntimeException(String.format("We are asking a region for a chunk out of bound | %s %s", chunkX, chunkZ));
        }
        int index = chunkX - this.field_23788.field_9181 + (chunkZ - this.field_23788.field_9180) * this.field_14088;
        class_2791 chunk = this.field_14098.get(index);
        this.chunkCache.put((Object)key, (Object)chunk);
        return chunk;
    }

    @Overwrite
    public class_2680 method_8320(class_2338 pos) {
        int chunkX = class_4076.method_18675((int)pos.method_10263());
        int chunkZ = class_4076.method_18675((int)pos.method_10260());
        return this.method_8392(chunkX, chunkZ).method_8320(pos);
    }

    @Overwrite
    public class_3610 method_8316(class_2338 pos) {
        int chunkX = class_4076.method_18675((int)pos.method_10263());
        int chunkZ = class_4076.method_18675((int)pos.method_10260());
        return this.method_8392(chunkX, chunkZ).method_8316(pos);
    }
}

