/*
 * Decompiled with CFR 0.152.
 */
package net.carbonmc.graphene.mixin.stack;

import java.util.Comparator;
import java.util.List;
import net.carbonmc.graphene.config.CoolConfig;
import net.minecraft.class_124;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.class_7923;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1542.class})
public abstract class ItemEntityMixin {
    private static final int MERGE_COOLDOWN_TICKS = 5;
    private static final int DEFAULT_MAX_STACK = 2147483547;
    @Unique
    private int lastMergeTick = -1;

    @Shadow
    public abstract class_1799 method_6983();

    @Shadow
    public abstract void method_6979(class_1799 var1);

    @Shadow
    public abstract void method_6976();

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void onTick(CallbackInfo ci) {
        if (!this.shouldProcess()) {
            return;
        }
        class_1542 self = (class_1542)this;
        this.updateStackDisplay(self);
        if (this.shouldAttemptMerge(self)) {
            this.lastMergeTick = (int)self.method_37908().method_8510();
            this.tryMergeItems(self);
        }
    }

    @Unique
    private boolean shouldProcess() {
        return (Boolean)CoolConfig.OpenIO.get() != false && !((class_1542)this).method_37908().field_9236;
    }

    @Unique
    private boolean shouldAttemptMerge(class_1542 self) {
        long gameTime = self.method_37908().method_8510();
        return this.lastMergeTick == -1 || gameTime - (long)this.lastMergeTick >= 5L;
    }

    @Unique
    private void tryMergeItems(class_1542 self) {
        if (!((Boolean)CoolConfig.OpenIO.get()).booleanValue()) {
            return;
        }
        class_1799 stack = self.method_6983();
        int maxStack = this.getEffectiveMaxStackSize();
        if (stack.method_7947() >= maxStack) {
            return;
        }
        List<class_1542> nearby = this.findMergeableItems(self);
        if (nearby.isEmpty()) {
            return;
        }
        this.performMerge(self, stack, maxStack, nearby);
    }

    @Unique
    private int getEffectiveMaxStackSize() {
        int configMax = (Integer)CoolConfig.maxStackSize.get();
        return configMax > 0 ? configMax : 2147483547;
    }

    @Unique
    private List<class_1542> findMergeableItems(class_1542 self) {
        double mergeDistance = (Double)CoolConfig.mergeDistance.get();
        int listMode = (Integer)CoolConfig.listMode.get();
        List itemList = (List)CoolConfig.itemList.get();
        class_1799 selfStack = self.method_6983();
        List nearby = self.method_37908().method_8390(class_1542.class, self.method_5829().method_1014(mergeDistance), e -> this.isValidMergeTarget(self, (class_1542)e, listMode, itemList));
        nearby.sort(Comparator.comparingDouble(arg_0 -> ((class_1542)self).method_5858(arg_0)));
        return nearby;
    }

    @Unique
    private void performMerge(class_1542 self, class_1799 stack, int maxStack, List<class_1542> nearby) {
        int remainingSpace = maxStack - stack.method_7947();
        for (class_1542 other : nearby) {
            if (remainingSpace <= 0) break;
            class_1799 otherStack = other.method_6983();
            int transfer = Math.min(otherStack.method_7947(), remainingSpace);
            stack.method_7933(transfer);
            self.method_6979(stack);
            self.method_6976();
            this.handleOtherStackAfterTransfer(other, otherStack, transfer);
            remainingSpace -= transfer;
        }
    }

    @Unique
    private void handleOtherStackAfterTransfer(class_1542 other, class_1799 otherStack, int transfer) {
        if (otherStack.method_7947() == transfer) {
            other.method_31472();
        } else {
            otherStack.method_7934(transfer);
            other.method_6979(otherStack);
            this.updateStackDisplay(other);
        }
    }

    @Unique
    private void updateStackDisplay(class_1542 entity) {
        if (!((Boolean)CoolConfig.OpenIO.get()).booleanValue() || !((Boolean)CoolConfig.showStackCount.get()).booleanValue()) {
            this.clearDisplay(entity);
            return;
        }
        class_1799 stack = entity.method_6983();
        if (stack.method_7947() > 1) {
            this.setStackCountDisplay(entity, stack.method_7947());
        } else {
            this.clearDisplay(entity);
        }
    }

    @Unique
    private void setStackCountDisplay(class_1542 entity, int count) {
        class_5250 countText = class_2561.method_43470((String)("\u00d7" + count)).method_27692(class_124.field_1077).method_27692(class_124.field_1067);
        entity.method_5665((class_2561)countText);
        entity.method_5880(true);
    }

    @Unique
    private void clearDisplay(class_1542 entity) {
        entity.method_5665(null);
        entity.method_5880(false);
    }

    @Unique
    private boolean isValidMergeTarget(class_1542 self, class_1542 other, int listMode, List<? extends String> itemList) {
        class_1799 otherStack;
        if (self == other || other.method_31481()) {
            return false;
        }
        class_1799 selfStack = self.method_6983();
        return this.isSameItem(selfStack, otherStack = other.method_6983()) && this.isMergeAllowed(otherStack, listMode, itemList) && ((Boolean)CoolConfig.lockMaxedStacks.get() == false || otherStack.method_7947() < this.getEffectiveMaxStackSize());
    }

    @Unique
    private boolean isSameItem(class_1799 a, class_1799 b) {
        return class_1799.method_31577((class_1799)a, (class_1799)b);
    }

    @Unique
    private boolean isMergeAllowed(class_1799 stack, int listMode, List<? extends String> itemList) {
        if (listMode == 0) {
            return true;
        }
        class_2960 id = class_7923.field_41178.method_10221((Object)stack.method_7909());
        if (id == null) {
            return false;
        }
        boolean inList = itemList.contains(id.toString());
        return listMode == 1 ? inList : !inList;
    }
}

