/*
 * Decompiled with CFR 0.152.
 */
package net.carbonmc.graphene.mixin.other;

import java.util.Set;
import net.carbonmc.graphene.util.KryoNBTUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.JigsawBlockEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={JigsawBlockEntity.class})
public abstract class MixinJigsawBlockEntity {
    @Unique
    private CompoundTag kryo$cachedTag;

    @Inject(method={"saveAdditional"}, at={@At(value="HEAD")}, cancellable=true)
    private void onSave(CompoundTag tag, CallbackInfo ci) {
        this.kryo$cachedTag = KryoNBTUtil.optimizeWrite(tag);
        if (this.kryo$cachedTag != tag) {
            Set keys = this.kryo$cachedTag.m_128431_();
            for (String key : keys) {
                if (tag.m_128441_(key)) continue;
                tag.m_128365_(key, this.kryo$cachedTag.m_128423_(key));
            }
            ci.cancel();
        }
    }

    @ModifyVariable(method={"load"}, at=@At(value="HEAD"), argsOnly=true)
    private CompoundTag onLoad(CompoundTag tag) {
        return KryoNBTUtil.optimizeRead(tag);
    }
}

