/*
 * Decompiled with CFR 0.152.
 */
package net.carbonmc.graphene.async.player;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import net.carbonmc.graphene.async.AsyncSystemInitializer;
import net.carbonmc.graphene.event.AsyncHandler;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@AsyncHandler(threadPool="io", fallbackToSync=false)
public class AsyncPlayerData {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final BlockingQueue<SaveTask> saveQueue = new LinkedBlockingQueue<SaveTask>(1000);
    private static final ConcurrentMap<UUID, LoadTask> loadTasks = new ConcurrentHashMap<UUID, LoadTask>();
    private static final int MAX_RETRIES = 3;
    private static final Path TEMP_DIR = Path.of("playerdata_tmp", new String[0]);

    public static void init() {
        try {
            Files.createDirectories(TEMP_DIR, new FileAttribute[0]);
            LOGGER.info("Async Player Data Manager initialized");
        }
        catch (IOException e) {
            LOGGER.error("Failed to initialize player data manager", (Throwable)e);
            throw new RuntimeException("Player data initialization failed", e);
        }
    }

    public static void shutdown() {
        saveQueue.clear();
        loadTasks.clear();
        LOGGER.info("Async Player Data Manager shutdown");
    }

    public static void savePlayerDataAsync(ServerPlayer player, Path dataDir) {
        if (player == null || dataDir == null) {
            LOGGER.warn("Invalid parameters for savePlayerDataAsync");
            return;
        }
        if (!saveQueue.offer(new SaveTask(player, dataDir))) {
            LOGGER.warn("Player data save queue full, data not saved for {}", (Object)player.m_7755_().getString());
        }
    }

    public static CompletableFuture<PlayerData> loadPlayerDataAsync(UUID playerId, Path dataDir) {
        if (playerId == null || dataDir == null) {
            return CompletableFuture.failedFuture(new IllegalArgumentException("Invalid parameters"));
        }
        LoadTask existingTask = (LoadTask)loadTasks.get(playerId);
        if (existingTask != null) {
            return existingTask.future();
        }
        LoadTask newTask = new LoadTask(playerId, dataDir);
        loadTasks.put(playerId, newTask);
        AsyncSystemInitializer.getThreadPool("io").execute(() -> {
            try {
                Path playerFile = dataDir.resolve(playerId.toString() + ".dat");
                PlayerData data = AsyncPlayerData.loadWithRetry(playerFile);
                newTask.result().set(data);
            }
            catch (Exception e) {
                LOGGER.error("Failed to load player data for {}", (Object)playerId, (Object)e);
                newTask.error().set(e);
            }
            finally {
                newTask.completed().set(true);
            }
        });
        return newTask.future();
    }

    private static PlayerData loadWithRetry(Path file) throws IOException, ClassNotFoundException {
        if (!Files.exists(file, new LinkOption[0])) {
            return null;
        }
        IOException lastException = null;
        int i = 0;
        while (i < 3) {
            PlayerData playerData;
            ObjectInputStream ois = new ObjectInputStream(Files.newInputStream(file, new OpenOption[0]));
            try {
                playerData = (PlayerData)ois.readObject();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ois.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    lastException = e;
                    if (i < 2) {
                        try {
                            Thread.sleep(100 * (i + 1));
                        }
                        catch (InterruptedException ie) {
                            Thread.currentThread().interrupt();
                            throw new IOException("Interrupted during retry", ie);
                        }
                    }
                    ++i;
                }
            }
            ois.close();
            return playerData;
        }
        throw lastException;
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            AsyncPlayerData.processSaveTasks();
            AsyncPlayerData.processLoadTasks();
        }
    }

    private static void processSaveTasks() {
        int processed = 0;
        while (processed < 50 && !saveQueue.isEmpty()) {
            SaveTask task = (SaveTask)saveQueue.poll();
            if (task == null) continue;
            ++processed;
            AsyncSystemInitializer.getThreadPool("io").execute(() -> AsyncPlayerData.saveWithRetry(task));
        }
    }

    private static void saveWithRetry(SaveTask task) {
        ServerPlayer player = task.player();
        if (player == null || player.m_213877_()) {
            LOGGER.warn("Player not available for data save");
            return;
        }
        UUID playerId = player.m_20148_();
        Path tempFile = TEMP_DIR.resolve(String.valueOf(playerId) + ".tmp");
        Path finalFile = task.dataDir().resolve(String.valueOf(playerId) + ".dat");
        try {
            Files.createDirectories(task.dataDir(), new FileAttribute[0]);
            try (ObjectOutputStream oos = new ObjectOutputStream(Files.newOutputStream(tempFile, new OpenOption[0]));){
                oos.writeObject(new PlayerData(player));
            }
            Files.move(tempFile, finalFile, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
            LOGGER.debug("Player data saved for {}", (Object)player.m_7755_().getString());
        }
        catch (Exception e) {
            LOGGER.error("Failed to save player data for {}", (Object)player.m_7755_().getString(), (Object)e);
            try {
                Files.deleteIfExists(tempFile);
            }
            catch (IOException ioException) {
                LOGGER.warn("Failed to delete temp file", (Throwable)ioException);
            }
        }
    }

    private static void processLoadTasks() {
        loadTasks.entrySet().removeIf(entry -> {
            LoadTask task = (LoadTask)entry.getValue();
            if (task.completed().get()) {
                if (task.error().get() != null) {
                    task.future().completeExceptionally(task.error().get());
                } else {
                    task.future().complete(task.result().get());
                }
                return true;
            }
            return false;
        });
    }

    private static class SaveTask {
        private final ServerPlayer player;
        private final Path dataDir;

        public SaveTask(ServerPlayer player, Path dataDir) {
            this.player = player;
            this.dataDir = dataDir;
        }

        public ServerPlayer player() {
            return this.player;
        }

        public Path dataDir() {
            return this.dataDir;
        }
    }

    private static class LoadTask {
        private final UUID playerId;
        private final Path dataDir;
        private final CompletableFuture<PlayerData> future = new CompletableFuture();
        private final AtomicReference<PlayerData> result = new AtomicReference();
        private final AtomicBoolean completed = new AtomicBoolean(false);
        private final AtomicReference<Exception> error = new AtomicReference();

        public LoadTask(UUID playerId, Path dataDir) {
            this.playerId = playerId;
            this.dataDir = dataDir;
        }

        public CompletableFuture<PlayerData> future() {
            return this.future;
        }

        public AtomicReference<PlayerData> result() {
            return this.result;
        }

        public AtomicBoolean completed() {
            return this.completed;
        }

        public AtomicReference<Exception> error() {
            return this.error;
        }
    }

    public static class PlayerData
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final UUID playerId;
        private final String playerName;
        private final long lastModified;

        public PlayerData(ServerPlayer player) {
            this.playerId = player.m_20148_();
            this.playerName = player.m_7755_().getString();
            this.lastModified = System.currentTimeMillis();
        }

        public UUID getPlayerId() {
            return this.playerId;
        }

        public String getPlayerName() {
            return this.playerName;
        }

        public long getLastModified() {
            return this.lastModified;
        }
    }
}

