/*
 * Decompiled with CFR 0.152.
 */
package net.carbonmc.graphene.optimization.chunk;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;
import net.carbonmc.graphene.Graphene;
import net.carbonmc.graphene.config.CoolConfig;
import net.carbonmc.graphene.optimization.chunk.AES;

public final class RE {
    private static final AtomicReference<AES> CPU_EXECUTOR_SERVICE = new AtomicReference();
    private static volatile long lastAccessTime = System.currentTimeMillis();
    private static final Object LOCK = new Object();

    private RE() {
        throw new UnsupportedOperationException("Utility class");
    }

    private static ExecutorService getCpuBackendExecutor() {
        lastAccessTime = System.currentTimeMillis();
        if (Graphene.CKU != null && Graphene.CKU.p != null && !Graphene.CKU.p.isShutdown()) {
            return Graphene.CKU.p;
        }
        return RE.getSharedExecutor();
    }

    private static ExecutorService getSharedExecutor() {
        return SharedExecutorHolder.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ExecutorService cpuService() {
        if (!((Boolean)CoolConfig.CTU.get()).booleanValue()) {
            return RE.getCpuBackendExecutor();
        }
        AES executor = CPU_EXECUTOR_SERVICE.get();
        if (executor == null || executor.isShutdown()) {
            Object object = LOCK;
            synchronized (object) {
                executor = CPU_EXECUTOR_SERVICE.get();
                if (executor == null || executor.isShutdown()) {
                    executor = new AES(RE::getCpuBackendExecutor, "Graphene-CPU-Proxy");
                    CPU_EXECUTOR_SERVICE.set(executor);
                }
            }
        }
        return executor;
    }

    public static long getLastAccessTime() {
        return lastAccessTime;
    }

    public static int getExecutedTaskCount() {
        AES executor = CPU_EXECUTOR_SERVICE.get();
        return executor != null ? executor.getExecutedTaskCount() : 0;
    }

    public static void shutdown() {
        AES executor = CPU_EXECUTOR_SERVICE.getAndSet(null);
        if (executor != null) {
            try {
                executor.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        AES.cleanupSharedExecutors();
    }

    private static class SharedExecutorHolder {
        static final ExecutorService INSTANCE = Executors.newWorkStealingPool(Math.max(2, Runtime.getRuntime().availableProcessors() / 2));

        private SharedExecutorHolder() {
        }
    }
}

