/*
 * Decompiled with CFR 0.152.
 */
package net.carbonmc.graphene.mixin;

import com.mojang.blaze3d.vertex.PoseStack;
import java.nio.FloatBuffer;
import net.carbonmc.graphene.Graphene;
import net.carbonmc.graphene.opencl.VertexBufferTracker;
import net.minecraft.client.Camera;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.culling.Frustum;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LevelRenderer.class})
public class WorldRendererMixin {
    private static final FloatBuffer MATRIX_BUFFER = FloatBuffer.allocate(16);

    @Inject(method={"setupRender"}, at={@At(value="HEAD")})
    private void onSetupRender(Camera camera, Frustum frustum, boolean isSpectator, boolean isFrustumUpdated, CallbackInfo ci) {
        Graphene graphene = Graphene.INSTANCE;
        if (graphene != null && graphene.getOpenCLManager() != null && !graphene.getOpenCLManager().isInitialized()) {
            try {
                graphene.getOpenCLManager().initialize();
            }
            catch (Exception e) {
                Graphene.LOGGER.error("Failed to reinitialize OpenCL during render setup", (Throwable)e);
            }
        }
    }

    @Inject(method={"renderLevel"}, at={@At(value="HEAD")})
    private void onRenderLevelStart(PoseStack poseStack, float partialTick, long finishNanoTime, boolean renderBlockOutline, Camera camera, GameRenderer gameRenderer, LightTexture lightTexture, Matrix4f projectionMatrix, CallbackInfo ci) {
        this.setCurrentMatrices(poseStack, projectionMatrix);
    }

    private void setCurrentMatrices(PoseStack poseStack, Matrix4f projectionMatrix) {
        Matrix4f modelViewMatrix = new Matrix4f((Matrix4fc)poseStack.m_85850_().m_252922_());
        Matrix4f projMatrix = new Matrix4f((Matrix4fc)projectionMatrix);
        VertexBufferTracker.setMatrices((float[])this.matrixToArray(modelViewMatrix), (float[])this.matrixToArray(projMatrix));
    }

    private float[] matrixToArray(Matrix4f matrix) {
        float[] result = new float[16];
        matrix.get(MATRIX_BUFFER);
        MATRIX_BUFFER.rewind();
        MATRIX_BUFFER.get(result);
        MATRIX_BUFFER.rewind();
        return result;
    }
}

