/*
 * Decompiled with CFR 0.152.
 */
package net.carbonmc.graphene;

import com.google.common.collect.Queues;
import com.mojang.brigadier.CommandDispatcher;
import java.lang.ref.Cleaner;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import net.carbonmc.graphene.client.GrapheneClient;
import net.carbonmc.graphene.command.KillMobsCommand;
import net.carbonmc.graphene.config.CoolConfig;
import net.carbonmc.graphene.gl.CleanerRunnable;
import net.minecraft.commands.CommandSourceStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.IExtensionPoint;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.launch.MixinBootstrap;

@Mod(value="graphene")
public class Graphene {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final String MODID = "graphene";
    public static final String VERSION = "1.7.6";
    private ExecutorService executorService;
    private static final ConcurrentLinkedQueue<CleanerRunnable> PENDING = Queues.newConcurrentLinkedQueue();
    private static final Cleaner CLEANER = Cleaner.create();

    public Graphene() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        IEventBus forgeEventBus = MinecraftForge.EVENT_BUS;
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)CoolConfig.SPEC);
        forgeEventBus.register((Object)this);
        modEventBus.addListener(this::setup);
        MixinBootstrap.init();
        modEventBus.addListener(this::commonSetup);
        MinecraftForge.EVENT_BUS.addListener(this::onServerStopping);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            MinecraftForge.EVENT_BUS.addListener(evt -> {
                if (evt.phase == TickEvent.Phase.END) {
                    this.onEndClientTick();
                }
            });
        }
        LOGGER.info("Initializing Graphene MOD v{}", (Object)VERSION);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> GrapheneClient::init);
        ModLoadingContext.get().registerExtensionPoint(IExtensionPoint.DisplayTest.class, () -> new IExtensionPoint.DisplayTest(() -> "ANY", (remote, isServer) -> true));
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        int processors = Runtime.getRuntime().availableProcessors();
        this.executorService = Executors.newWorkStealingPool(Math.max(2, processors / 2));
    }

    private void onEndClientTick() {
        int drained = 0;
        while (!PENDING.isEmpty() && drained++ < 16) {
            CleanerRunnable r = PENDING.poll();
            if (r == null) continue;
            r.run();
        }
    }

    private void onServerStopping(ServerStoppingEvent event) {
        LOGGER.info("Shutting down Graphene systems...");
        if (this.executorService != null && !this.executorService.isShutdown()) {
            try {
                List<Runnable> remaining;
                this.executorService.shutdown();
                if (!this.executorService.awaitTermination(2L, TimeUnit.SECONDS) && !(remaining = this.executorService.shutdownNow()).isEmpty()) {
                    LOGGER.debug("Force shutdown {} remaining tasks", (Object)remaining.size());
                }
            }
            catch (InterruptedException e) {
                this.executorService.shutdownNow();
                Thread.currentThread().interrupt();
            }
        }
        LOGGER.info("Graphene shutdown complete");
    }

    private void setup(FMLCommonSetupEvent event) {
        LOGGER.info("Graphene Mod \u521d\u59cb\u5316\u5b8c\u6210");
    }

    @SubscribeEvent
    public void onRegisterCommands(RegisterCommandsEvent event) {
        KillMobsCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }
}

