/*
 * Decompiled with CFR 0.152.
 */
package net.carbonmc.graphene.TickHelper;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import net.carbonmc.graphene.api.IOptimizableEntity;
import net.carbonmc.graphene.config.CoolConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber
public final class EntityTickHelper {
    private static final AtomicReference<Set<EntityType<?>>> ENTITY_WHITELIST = new AtomicReference(Collections.emptySet());
    private static final AtomicReference<Set<Item>> ITEM_WHITELIST = new AtomicReference(Collections.emptySet());
    private static final Cache<EntityType<?>, Boolean> BOSS_MOB_CACHE = Caffeine.newBuilder().maximumSize(100L).executor(Runnable::run).build();
    private static final Set<EntityType<?>> BOSS_TYPES = ImmutableSet.of((Object)EntityType.f_20565_, (Object)EntityType.f_20496_, (Object)EntityType.f_20563_, (Object)EntityType.f_217015_);
    private static final ExecutorService TICK_EXECUTOR = Executors.newWorkStealingPool();
    private static volatile boolean optimizeEntitiesEnabled = true;
    private static volatile boolean tickRaidersInRaid = true;
    private static volatile int horizontalRange = 32;
    private static volatile int verticalRange = 16;

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            EntityTickHelper.updateConfigCache();
        }
    }

    private static void updateConfigCache() {
        optimizeEntitiesEnabled = (Boolean)CoolConfig.optimizeEntities.get();
        tickRaidersInRaid = (Boolean)CoolConfig.tickRaidersInRaid.get();
        horizontalRange = (Integer)CoolConfig.horizontalRange.get();
        verticalRange = (Integer)CoolConfig.verticalRange.get();
    }

    public static void refreshWhitelists() {
        CompletableFuture.runAsync(() -> {
            ENTITY_WHITELIST.set((Set<EntityType<?>>)ImmutableSet.copyOf((Collection)((List)CoolConfig.entityWhitelist.get()).stream().map(s -> (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(s))).filter(Objects::nonNull).collect(Collectors.toSet())));
            ITEM_WHITELIST.set((Set<Item>)ImmutableSet.copyOf((Collection)((List)CoolConfig.itemWhitelist.get()).stream().map(s -> (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(s))).filter(Objects::nonNull).collect(Collectors.toSet())));
        }, TICK_EXECUTOR);
    }

    public static boolean shouldCancelTick(@NotNull Entity entity) {
        IOptimizableEntity opt;
        LivingEntity living;
        if (!optimizeEntitiesEnabled) {
            return false;
        }
        Level level = entity.m_9236_();
        if (level == null) {
            return false;
        }
        if (entity instanceof Player || ENTITY_WHITELIST.get().contains(entity.m_6095_()) || entity instanceof Raider) {
            return false;
        }
        if (!(entity instanceof LivingEntity) || !(living = (LivingEntity)entity).m_6084_()) {
            return false;
        }
        if (entity instanceof IOptimizableEntity && (opt = (IOptimizableEntity)entity).shouldAlwaysTick()) {
            return false;
        }
        return EntityTickHelper.performFullChecks(living, level);
    }

    private static boolean performFullChecks(LivingEntity entity, Level level) {
        BlockPos pos = entity.m_20183_();
        EntityType type = entity.m_6095_();
        if (EntityTickHelper.isBossMob(type, entity)) {
            return false;
        }
        if (tickRaidersInRaid && EntityTickHelper.isInRaid((Entity)entity, level, pos)) {
            return false;
        }
        return !EntityTickHelper.checkNearbyPlayers(level, pos);
    }

    private static boolean isBossMob(EntityType<?> type, LivingEntity entity) {
        return BOSS_TYPES.contains(type) || (Boolean)BOSS_MOB_CACHE.get(type, t -> {
            Mob mob;
            return entity instanceof Mob && (mob = (Mob)entity).m_21525_();
        }) != false;
    }

    private static boolean isInRaid(Entity entity, Level level, BlockPos pos) {
        IOptimizableEntity opt;
        ServerLevel serverLevel;
        return level instanceof ServerLevel && (serverLevel = (ServerLevel)level).m_8843_(pos) && (entity instanceof Raider || entity instanceof IOptimizableEntity && (opt = (IOptimizableEntity)entity).shouldTickInRaid());
    }

    private static boolean checkNearbyPlayers(Level level, BlockPos pos) {
        horizontalRange = Math.min(horizontalRange, 128);
        verticalRange = Math.min(verticalRange, 64);
        if (level.m_6907_().isEmpty()) {
            return false;
        }
        AABB area = new AABB((double)(pos.m_123341_() - horizontalRange), (double)(pos.m_123342_() - verticalRange), (double)(pos.m_123343_() - horizontalRange), (double)(pos.m_123341_() + horizontalRange), (double)(pos.m_123342_() + verticalRange), (double)(pos.m_123343_() + horizontalRange));
        List players = level.m_45976_(Player.class, area);
        for (Player player : players) {
            if (!player.m_6084_()) continue;
            return true;
        }
        return false;
    }

    public static void shutdown() {
        TICK_EXECUTOR.shutdownNow();
        try {
            if (!TICK_EXECUTOR.awaitTermination(1L, TimeUnit.SECONDS)) {
                TICK_EXECUTOR.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            TICK_EXECUTOR.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    static {
        EntityTickHelper.refreshWhitelists();
        EntityTickHelper.updateConfigCache();
    }
}

