/*
 * Decompiled with CFR 0.152.
 */
package net.carbonmc.graphene.client.resources;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@OnlyIn(value=Dist.CLIENT)
public class ResourceManager
implements ResourceManagerReloadListener {
    private static final int MAX_CACHED_RESOURCES = 1000;
    private static final Cache<String, byte[]> resourceCache = Caffeine.newBuilder().maximumSize(1000L).build();

    @SubscribeEvent
    public static void onRegisterReloadListeners(RegisterClientReloadListenersEvent event) {
        event.registerReloadListener((PreparableReloadListener)new ResourceManager());
    }

    public void m_6213_(net.minecraft.server.packs.resources.ResourceManager resourceManager) {
        resourceCache.invalidateAll();
    }

    @Nullable
    public static byte[] getCompressedResource(String path) {
        Objects.requireNonNull(path, "Resource path cannot be null");
        if (path.isEmpty()) {
            throw new IllegalArgumentException("Resource path cannot be empty");
        }
        return (byte[])resourceCache.get((Object)path, k -> {
            byte[] byArray;
            block9: {
                InputStream input = ResourceManager.class.getResourceAsStream(path);
                try {
                    if (input == null) {
                        throw new IOException("Resource not found: " + path);
                    }
                    byArray = input.readAllBytes();
                    if (input == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (input != null) {
                            try {
                                input.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Failed to load resource: " + path, e);
                    }
                }
                input.close();
            }
            return byArray;
        });
    }
}

