/*
 * Decompiled with CFR 0.152.
 */
package net.carbonmc.graphene.engine.cull;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public final class AsyncTracer {
    private static final AtomicInteger THREAD_COUNTER = new AtomicInteger();
    private static final ExecutorService TRACER_POOL = Executors.newFixedThreadPool(Math.max(2, Runtime.getRuntime().availableProcessors() / 2), r -> new Thread(r, "AsyncTracer-" + THREAD_COUNTER.incrementAndGet()));
    private static final Cache<Long, Boolean> TRACE_CACHE = Caffeine.newBuilder().maximumSize(10000L).expireAfterWrite(500L, TimeUnit.MILLISECONDS).build();

    public static CompletableFuture<Boolean> traceAsync(Vec3 start, Vec3 end, BlockGetter level) {
        long cacheKey = AsyncTracer.computeTraceHash(start, end);
        Boolean cached = (Boolean)TRACE_CACHE.getIfPresent((Object)cacheKey);
        if (cached != null) {
            return CompletableFuture.completedFuture(cached);
        }
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        TRACER_POOL.execute(() -> {
            try {
                boolean result = AsyncTracer.traceVisibility(start, end, level);
                TRACE_CACHE.put((Object)cacheKey, (Object)result);
                future.complete(result);
            }
            catch (Exception e) {
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    private static long computeTraceHash(Vec3 start, Vec3 end) {
        return (long)Float.floatToIntBits((float)start.f_82479_) << 48 | (long)Float.floatToIntBits((float)start.f_82480_) << 32 | (long)Float.floatToIntBits((float)start.f_82481_) << 16 | (long)Float.floatToIntBits((float)end.f_82479_) << 12 | (long)Float.floatToIntBits((float)end.f_82480_) << 8 | (long)Float.floatToIntBits((float)end.f_82481_);
    }

    private static boolean traceVisibility(Vec3 start, Vec3 end, BlockGetter level) {
        Vec3 dir = end.m_82546_(start);
        double dist = dir.m_82553_();
        if (dist < 0.001) {
            return true;
        }
        dir = dir.m_82541_();
        double step = Math.min(0.25, dist / 20.0);
        Vec3 current = start;
        BlockPos.MutableBlockPos mpos = new BlockPos.MutableBlockPos();
        while (current.m_82554_(start) < dist) {
            VoxelShape shape;
            mpos.m_122169_(current.f_82479_, current.f_82480_, current.f_82481_);
            BlockState state = level.m_8055_((BlockPos)mpos);
            if (!state.m_60795_() && !(shape = state.m_60812_(level, (BlockPos)mpos)).m_83281_() && shape.m_83215_().m_82338_((BlockPos)mpos).m_82390_(current)) {
                return false;
            }
            current = current.m_82549_(dir.m_82490_(step));
        }
        return true;
    }

    public static void shutdown() {
        TRACER_POOL.shutdownNow();
    }
}

