/*
 * Decompiled with CFR 0.152.
 */
package net.carbonmc.graphene.mixin.client.renderer.particle;

import java.util.List;
import java.util.Random;
import net.carbonmc.graphene.config.CoolConfig;
import net.carbonmc.graphene.mixin.client.renderer.particle.ParticleAccessor;
import net.carbonmc.graphene.util.VersionChecker;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@OnlyIn(value=Dist.CLIENT)
@Mixin(value={ParticleEngine.class})
public abstract class MixinParticleEngine {
    @Unique
    private static final Random RANDOM = new Random();

    @Inject(method={"tickParticle"}, at={@At(value="HEAD")}, cancellable=true)
    private void onTickParticle(Particle particle, CallbackInfo ci) {
        if (VersionChecker.shouldDisableOptimizations() || !((Boolean)CoolConfig.ENABLE_PARTICLE_OPTIMIZATION.get()).booleanValue()) {
            return;
        }
        if (!((Boolean)CoolConfig.ENABLE_PARTICLE_OPTIMIZATION.get()).booleanValue() || !((Boolean)CoolConfig.ENABLE_PARTICLE_LOD.get()).booleanValue()) {
            return;
        }
        if (this.shouldApplyLOD(particle)) {
            this.handleParticleLOD(particle);
        }
    }

    @Unique
    private void handleParticleLOD(Particle particle) {
        double threshold;
        Camera camera = Minecraft.m_91087_().f_91063_.m_109153_();
        double distanceSq = particle.getPos().m_82557_(camera.m_90583_());
        if (distanceSq > (threshold = ((Double)CoolConfig.LOD_DISTANCE_THRESHOLD.get()).doubleValue()) * threshold) {
            if (RANDOM.nextDouble() > (Double)CoolConfig.LOD_REDUCTION_FACTOR.get()) {
                ((ParticleAccessor)particle).setAlphaAccessor(0.0f);
            } else {
                ((ParticleAccessor)particle).setAlphaAccessor(1.0f);
            }
        } else {
            ((ParticleAccessor)particle).setAlphaAccessor(1.0f);
        }
    }

    @Unique
    private boolean shouldApplyLOD(Particle particle) {
        String name = particle.getClass().getName().toLowerCase();
        List whitelist = (List)CoolConfig.LOD_PARTICLE_WHITELIST.get();
        List blacklist = (List)CoolConfig.LOD_PARTICLE_BLACKLIST.get();
        for (String black : blacklist) {
            if (!name.contains(black.toLowerCase())) continue;
            return false;
        }
        for (String white : whitelist) {
            if (!name.contains(white.toLowerCase())) continue;
            return true;
        }
        return this.isLowPriorityParticle(particle);
    }

    @Unique
    private boolean isLowPriorityParticle(Particle particle) {
        String name = particle.getClass().getName().toLowerCase();
        return name.contains("rain") || name.contains("snow") || name.contains("cloud") || name.contains("ash") || name.contains("drip") || name.contains("spore");
    }
}

