/*
 * Decompiled with CFR 0.152.
 */
package net.carbonmc.graphene.async.world;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import net.carbonmc.graphene.async.AsyncSystemInitializer;
import net.carbonmc.graphene.event.AsyncHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@AsyncHandler(threadPool="compute", fallbackToSync=true)
public class StructureGenAsync {
    private static final Logger LOGGER = LogManager.getLogger((String)"StructureGenAsync");
    private static final int MAX_RETRIES = 5;
    private static final int MAX_TASKS_PER_TICK = 50;
    private static final int CHUNK_LOAD_RADIUS = 2;
    private static final long TASK_TIMEOUT_MS = 30000L;
    private static final int MAX_QUEUE_SIZE = 1000;
    private static final int MAX_CONCURRENT_TASKS = 200;
    private static final long CACHE_EXPIRE_MINUTES = 5L;
    private static final long CACHE_MAX_SIZE = 1000L;
    private static final BlockingQueue<StructureTask> structureQueue = new LinkedBlockingQueue<StructureTask>(1000);
    private static final Semaphore taskSemaphore = new Semaphore(200);
    private static final Cache<ChunkPosKey, Boolean> chunkStatusCache = Caffeine.newBuilder().maximumSize(1000L).expireAfterWrite(5L, TimeUnit.MINUTES).build();

    public static void init() {
        LOGGER.info("Async Structure Generator initialized with queue size: {}, max tasks: {}", (Object)1000, (Object)200);
    }

    public static void shutdown() {
        structureQueue.clear();
        chunkStatusCache.invalidateAll();
        LOGGER.info("Async Structure Generator shutdown completed");
    }

    public static CompletableFuture<Void> placeStructureAsync(ServerLevel level, StructureTemplate template, BlockPos pos) {
        if (level == null || template == null || pos == null) {
            return CompletableFuture.failedFuture(new IllegalArgumentException("Invalid parameters"));
        }
        if (!level.m_46749_(pos)) {
            LOGGER.warn("Attempted to place structure at unloaded position {}", (Object)pos);
            return CompletableFuture.failedFuture(new IllegalStateException("Position unloaded"));
        }
        if (!taskSemaphore.tryAcquire()) {
            LOGGER.warn("Too many concurrent structure generation tasks, skipping {}", (Object)pos);
            return CompletableFuture.failedFuture(new IllegalStateException("Too many concurrent tasks"));
        }
        StructureTask task = new StructureTask(level, template, pos);
        if (!structureQueue.offer(task)) {
            taskSemaphore.release();
            LOGGER.warn("Structure queue full, skipping generation at {}", (Object)pos);
            return CompletableFuture.failedFuture(new IllegalStateException("Queue full"));
        }
        return task.future().whenComplete((r, e) -> taskSemaphore.release());
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            StructureGenAsync.processStructureTasks();
        }
    }

    private static void processStructureTasks() {
        int processed = 0;
        while (processed < 50 && !structureQueue.isEmpty()) {
            StructureTask task = (StructureTask)structureQueue.poll();
            if (task == null) continue;
            ++processed;
            StructureGenAsync.processSingleTask(task);
        }
    }

    private static void processSingleTask(StructureTask task) {
        AsyncSystemInitializer.getThreadPool("compute").execute(() -> {
            try {
                if (StructureGenAsync.isTaskTimedOut(task)) {
                    StructureGenAsync.handleTaskTimeout(task);
                    return;
                }
                if (StructureGenAsync.exceededMaxRetries(task)) {
                    StructureGenAsync.handleMaxRetriesExceeded(task);
                    return;
                }
                if (!StructureGenAsync.isAreaReadyForGeneration(task)) {
                    StructureGenAsync.retryTask(task);
                    return;
                }
                StructureGenAsync.placeStructureSafely(task);
                task.future().complete(null);
            }
            catch (Exception e) {
                LOGGER.error("Failed to place structure at {}", (Object)task.pos(), (Object)e);
                task.future().completeExceptionally(e);
            }
        });
    }

    private static boolean isTaskTimedOut(StructureTask task) {
        return System.currentTimeMillis() - task.creationTime() > 30000L;
    }

    private static void handleTaskTimeout(StructureTask task) {
        LOGGER.error("Structure generation timed out at {}", (Object)task.pos());
        task.future().completeExceptionally(new TimeoutException("Operation timed out"));
    }

    private static boolean exceededMaxRetries(StructureTask task) {
        return task.retryCount().incrementAndGet() > 5;
    }

    private static void handleMaxRetriesExceeded(StructureTask task) {
        LOGGER.error("Structure generation failed after {} retries at {}", (Object)5, (Object)task.pos());
        task.future().completeExceptionally(new TimeoutException("Max retries exceeded"));
    }

    private static boolean isAreaReadyForGeneration(StructureTask task) {
        return StructureGenAsync.isAreaLoaded(task.level(), task.pos()) && StructureGenAsync.isTerrainReady(task.level(), task.pos());
    }

    private static boolean isAreaLoaded(ServerLevel level, BlockPos pos) {
        try {
            return level.isAreaLoaded(pos, 2);
        }
        catch (Exception e) {
            LOGGER.warn("Failed to check area load status at {}", (Object)pos, (Object)e);
            return false;
        }
    }

    private static boolean isTerrainReady(ServerLevel level, BlockPos pos) {
        int chunkX = pos.m_123341_() >> 4;
        int chunkZ = pos.m_123343_() >> 4;
        ChunkPosKey key = new ChunkPosKey(level.m_46472_().m_135782_().toString(), chunkX, chunkZ);
        try {
            return (Boolean)chunkStatusCache.get((Object)key, k -> StructureGenAsync.checkChunkStatus(level, chunkX, chunkZ));
        }
        catch (Exception e) {
            LOGGER.warn("Cache lookup failed for terrain status at [{}, {}]", (Object)chunkX, (Object)chunkZ, (Object)e);
            return false;
        }
    }

    private static boolean checkChunkStatus(ServerLevel level, int chunkX, int chunkZ) {
        try {
            return level.m_7726_().m_7587_(chunkX, chunkZ, ChunkStatus.f_62322_, false).m_6415_().m_62427_(ChunkStatus.f_62322_);
        }
        catch (Exception e) {
            LOGGER.warn("Failed to check terrain status at [{}, {}]", (Object)chunkX, (Object)chunkZ, (Object)e);
            return false;
        }
    }

    private static void placeStructureSafely(StructureTask task) {
        try {
            task.template().m_230328_((ServerLevelAccessor)task.level(), task.pos(), task.pos(), new StructurePlaceSettings(), task.level().f_46441_, 2);
            LOGGER.debug("Successfully placed structure at {}", (Object)task.pos());
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to place structure", e);
        }
    }

    private static void retryTask(StructureTask task) {
        try {
            if (!structureQueue.offer(task)) {
                LOGGER.warn("Failed to retry structure generation at {}, queue full", (Object)task.pos());
                task.future().completeExceptionally(new IllegalStateException("Queue full during retry"));
            }
        }
        catch (Exception e) {
            LOGGER.error("Error during task retry at {}", (Object)task.pos(), (Object)e);
            task.future().completeExceptionally(e);
        }
    }

    private static class StructureTask {
        private final ServerLevel level;
        private final StructureTemplate template;
        private final BlockPos pos;
        private final AtomicInteger retryCount = new AtomicInteger(0);
        private final long creationTime = System.currentTimeMillis();
        private final CompletableFuture<Void> future = new CompletableFuture();

        public StructureTask(ServerLevel level, StructureTemplate template, BlockPos pos) {
            this.level = level;
            this.template = template;
            this.pos = pos;
        }

        public ServerLevel level() {
            return this.level;
        }

        public StructureTemplate template() {
            return this.template;
        }

        public BlockPos pos() {
            return this.pos;
        }

        public AtomicInteger retryCount() {
            return this.retryCount;
        }

        public long creationTime() {
            return this.creationTime;
        }

        public CompletableFuture<Void> future() {
            return this.future;
        }
    }

    private static class ChunkPosKey {
        private final String dimension;
        private final int chunkX;
        private final int chunkZ;

        public ChunkPosKey(String dimension, int chunkX, int chunkZ) {
            this.dimension = dimension;
            this.chunkX = chunkX;
            this.chunkZ = chunkZ;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ChunkPosKey that = (ChunkPosKey)o;
            return this.chunkX == that.chunkX && this.chunkZ == that.chunkZ && this.dimension.equals(that.dimension);
        }

        public int hashCode() {
            return 31 * (31 * this.dimension.hashCode() + this.chunkX) + this.chunkZ;
        }
    }
}

