/*
 * Decompiled with CFR 0.152.
 */
package net.carbonmc.graphene.engine.cull;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.EnumMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import net.carbonmc.graphene.config.CoolConfig;
import net.carbonmc.graphene.engine.cull.RenderOptimizer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;

public final class LeafOptiEngine {
    private static final Map<Direction, Direction[]> CONNECTED_DIRECTIONS = new EnumMap<Direction, Direction[]>(Direction.class);
    private static final Cache<Long, Boolean> CULL_CACHE = Caffeine.newBuilder().maximumSize(10000L).expireAfterWrite(1L, TimeUnit.SECONDS).build();

    public static boolean shouldCullFace(BlockGetter level, BlockPos pos, Direction face) {
        long cacheKey = pos.m_121878_() << 8 | (long)face.ordinal();
        Boolean cached = (Boolean)CULL_CACHE.getIfPresent((Object)cacheKey);
        if (cached != null) {
            return cached;
        }
        BlockPos adjacentPos = pos.m_121945_(face);
        BlockState adjacentState = level.m_8055_(adjacentPos);
        if (!LeafOptiEngine.isLeaf(adjacentState)) {
            CULL_CACHE.put((Object)cacheKey, (Object)false);
            return false;
        }
        boolean result = (Boolean)CoolConfig.useAdvancedLeafCulling.get() != false && !RenderOptimizer.isInFallbackMode() ? RenderOptimizer.shouldCullBlockFace(level, pos, face) : LeafOptiEngine.checkSimpleConnection(level, adjacentPos, face);
        CULL_CACHE.put((Object)cacheKey, (Object)result);
        return result;
    }

    public static boolean checkSimpleConnection(BlockGetter level, BlockPos pos, Direction face) {
        int required = (Integer)CoolConfig.minLeafConnections.get();
        int count = 0;
        for (Direction dir : CONNECTED_DIRECTIONS.get(face)) {
            if (dir == null || !LeafOptiEngine.isLeaf(level.m_8055_(pos.m_121945_(dir))) || ++count < required) continue;
            return true;
        }
        return false;
    }

    public static boolean checkSimpleConnection(BlockGetter level, BlockPos pos) {
        return LeafOptiEngine.checkConnectedLeaves(level, pos, null);
    }

    public static boolean checkConnectedLeaves(BlockGetter level, BlockPos pos, @Nullable Direction face) {
        Direction[] checkDirs;
        int required = (Integer)CoolConfig.minLeafConnections.get();
        int count = 0;
        for (Direction dir : checkDirs = face != null ? CONNECTED_DIRECTIONS.get(face) : Direction.values()) {
            if (dir == null || !LeafOptiEngine.isLeaf(level.m_8055_(pos.m_121945_(dir))) || ++count < required) continue;
            return true;
        }
        return false;
    }

    private static boolean isLeaf(BlockState state) {
        return state.m_60734_() instanceof LeavesBlock;
    }

    static {
        for (Direction face : Direction.values()) {
            Direction[] dirs = new Direction[4];
            int i = 0;
            for (Direction dir : Direction.values()) {
                if (dir == face || dir == face.m_122424_()) continue;
                dirs[i++] = dir;
            }
            CONNECTED_DIRECTIONS.put(face, dirs);
        }
    }
}

