/*
 * Decompiled with CFR 0.152.
 */
package net.carbonmc.graphene.optimization.chunk;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import net.carbonmc.graphene.config.CoolConfig;
import net.carbonmc.graphene.optimization.chunk.ChunkOptif;
import net.carbonmc.graphene.optimization.chunk.GlobalExecutorManager;
import org.jetbrains.annotations.NotNull;

public final class AES
extends AbstractExecutorService
implements AutoCloseable {
    private final Supplier<ExecutorService> executorProvider;
    private volatile boolean active = true;
    private final String name;
    private final AtomicInteger executedTasks = new AtomicInteger();

    public AES(Supplier<ExecutorService> executorProvider, String name) {
        this.executorProvider = executorProvider;
        this.name = name;
        GlobalExecutorManager.registerResource(this);
    }

    @Override
    public void execute(@NotNull Runnable command) {
        if (!((Boolean)CoolConfig.CTU.get()).booleanValue() || !this.active) {
            command.run();
            return;
        }
        this.executedTasks.incrementAndGet();
        Long currentRegionId = ChunkOptif.currentRegion();
        if (currentRegionId == null) {
            this.executorProvider.get().execute(command);
        } else {
            this.executorProvider.get().execute(() -> {
                try {
                    ChunkOptif.go(currentRegionId);
                    command.run();
                }
                catch (Throwable throwable) {
                }
                finally {
                    ChunkOptif.to();
                    ChunkOptif.cleanupThreadState();
                }
            });
        }
    }

    @Override
    public void shutdown() {
        this.active = false;
        ExecutorService executor = this.executorProvider.get();
        if (executor != null) {
            executor.shutdown();
        }
    }

    @Override
    @NotNull
    public List<Runnable> shutdownNow() {
        this.active = false;
        ExecutorService executor = this.executorProvider.get();
        return executor != null ? executor.shutdownNow() : List.of();
    }

    @Override
    public boolean isShutdown() {
        return !this.active || this.executorProvider.get() != null && this.executorProvider.get().isShutdown();
    }

    @Override
    public boolean isTerminated() {
        ExecutorService executor = this.executorProvider.get();
        return executor != null && executor.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        ExecutorService executor = this.executorProvider.get();
        return executor != null && executor.awaitTermination(timeout, unit);
    }

    @Override
    @NotNull
    public <T> Future<T> submit(@NotNull Callable<T> task) {
        this.executedTasks.incrementAndGet();
        return this.executorProvider.get().submit(task);
    }

    @Override
    @NotNull
    public <T> Future<T> submit(@NotNull Runnable task, T result) {
        this.executedTasks.incrementAndGet();
        return this.executorProvider.get().submit(task, result);
    }

    @Override
    @NotNull
    public Future<?> submit(@NotNull Runnable task) {
        this.executedTasks.incrementAndGet();
        return this.executorProvider.get().submit(task);
    }

    @Override
    @NotNull
    public <T> List<Future<T>> invokeAll(@NotNull Collection<? extends Callable<T>> tasks) throws InterruptedException {
        this.executedTasks.addAndGet(tasks.size());
        return this.executorProvider.get().invokeAll(tasks);
    }

    @Override
    @NotNull
    public <T> List<Future<T>> invokeAll(@NotNull Collection<? extends Callable<T>> tasks, long timeout, @NotNull TimeUnit unit) throws InterruptedException {
        this.executedTasks.addAndGet(tasks.size());
        return this.executorProvider.get().invokeAll(tasks, timeout, unit);
    }

    public int getExecutedTaskCount() {
        return this.executedTasks.get();
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void close() throws Exception {
    }
}

