/*
 * Decompiled with CFR 0.152.
 */
package net.carbonmc.graphene.optimization.chunk;

import java.util.ArrayDeque;
import java.util.Deque;
import net.carbonmc.graphene.config.CoolConfig;
import net.carbonmc.graphene.optimization.chunk.LightingContext;
import net.minecraft.world.level.ChunkPos;

public final class ChunkOptif {
    private static final ThreadLocal<Deque<Long>> REGION_STACK = ThreadLocal.withInitial(ArrayDeque::new);
    private static final ThreadLocal<Boolean> STATE_VALID = ThreadLocal.withInitial(() -> true);
    private static final int REGION_SIZE_SHIFT = 4;
    private static final long COORDINATE_MASK = 0xFFFFFFFFL;
    private static final int MAX_STACK_DEPTH = 32;

    private ChunkOptif() {
        throw new UnsupportedOperationException("Utility class");
    }

    public static long toid(ChunkPos chunkPosition) {
        int chunkX = chunkPosition.f_45578_;
        int chunkZ = chunkPosition.f_45579_;
        int regionX = chunkX >> 4;
        int regionZ = chunkZ >> 4;
        return ((long)regionX & 0xFFFFFFFFL) << 32 | (long)regionZ & 0xFFFFFFFFL;
    }

    public static void go(long regionIdentifier) {
        if (!((Boolean)CoolConfig.CTU.get()).booleanValue()) {
            return;
        }
        Deque<Long> stack = REGION_STACK.get();
        if (stack.size() < 32) {
            stack.addLast(regionIdentifier);
            STATE_VALID.set(true);
        } else {
            STATE_VALID.set(false);
            ChunkOptif.cleanupThreadState();
        }
    }

    public static void to() {
        if (!((Boolean)CoolConfig.CTU.get()).booleanValue()) {
            return;
        }
        Deque<Long> stack = REGION_STACK.get();
        if (!stack.isEmpty()) {
            stack.pollLast();
        }
        if (stack.isEmpty()) {
            STATE_VALID.set(true);
        }
    }

    public static Long currentRegion() {
        if (!STATE_VALID.get().booleanValue()) {
            ChunkOptif.cleanupThreadState();
            return null;
        }
        Deque<Long> stack = REGION_STACK.get();
        return stack.isEmpty() ? null : stack.peekLast();
    }

    public static void cleanupThreadState() {
        REGION_STACK.get().clear();
        STATE_VALID.set(true);
        LightingContext.validateLightingState();
    }

    public static void validateAndRepair() {
        Deque<Long> stack = REGION_STACK.get();
        if (stack.size() > 32) {
            ChunkOptif.cleanupThreadState();
        }
        STATE_VALID.set(stack.size() <= 32);
    }
}

