/*
 * Decompiled with CFR 0.152.
 */
package net.carbonmc.graphene.config;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraftforge.common.ForgeConfigSpec;

public class CoolConfig {
    public static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static ForgeConfigSpec SPEC;
    private static Consumer<Void> changeListener;
    public static final ForgeConfigSpec.BooleanValue ENABLE_PARTICLE_OPTIMIZATION;
    public static final ForgeConfigSpec.BooleanValue ENABLE_PARTICLE_LOD;
    public static final ForgeConfigSpec.DoubleValue LOD_DISTANCE_THRESHOLD;
    public static final ForgeConfigSpec.DoubleValue LOD_REDUCTION_FACTOR;
    public static final ForgeConfigSpec.BooleanValue ENABLE_FIXED_TIMESTEP;
    public static final ForgeConfigSpec.DoubleValue FIXED_TIMESTEP_INTERVAL;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> LOD_PARTICLE_WHITELIST;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> LOD_PARTICLE_BLACKLIST;
    public static final ForgeConfigSpec.BooleanValue fpsoo;
    public static final ForgeConfigSpec.BooleanValue ENABLE_FIXED_LIGHT;
    public static final ForgeConfigSpec.BooleanValue enableReflex;
    public static final ForgeConfigSpec.LongValue reflexOffsetNs;
    public static final ForgeConfigSpec.BooleanValue reflexDebug;
    public static final ForgeConfigSpec.IntValue MAX_FPS;
    public static final ForgeConfigSpec.BooleanValue skipOutlineWhenNoGlowing;
    public static final ForgeConfigSpec.BooleanValue FIX_PEARL_LEAK;
    public static final ForgeConfigSpec.BooleanValue FIX_PROJECTILE_LERP;
    public static final ForgeConfigSpec.BooleanValue BambooLight;
    public static final ForgeConfigSpec.BooleanValue ENABLEDCULL;
    public static final ForgeConfigSpec.IntValue CULLING_DEPTH;
    public static final ForgeConfigSpec.DoubleValue REJECTION_RATE;
    public static final ForgeConfigSpec.BooleanValue ULTRA_CULLING;
    public static final ForgeConfigSpec.IntValue ULTRA_DEPTH;
    public static final ForgeConfigSpec.DoubleValue ULTRA_BACKFACE;
    public static final ForgeConfigSpec.BooleanValue ADVANCED_CULLING;
    public static final ForgeConfigSpec.BooleanValue REDUCE_FPS_WHEN_INACTIVE;
    public static final ForgeConfigSpec.IntValue INACTIVE_FPS_LIMIT;
    public static final ForgeConfigSpec.BooleanValue REDUCE_RENDER_DISTANCE_WHEN_INACTIVE;
    public static final ForgeConfigSpec.IntValue INACTIVE_RENDER_DISTANCE;
    public static ForgeConfigSpec.BooleanValue useAsyncTracing;
    public static ForgeConfigSpec.IntValue tracingThreads;
    public static ForgeConfigSpec.DoubleValue traceDistance;
    public static ForgeConfigSpec.DoubleValue fallbackDistance;
    public static ForgeConfigSpec.BooleanValue useAdvancedLeafCulling;
    public static ForgeConfigSpec.IntValue minLeafConnections;
    public static final ForgeConfigSpec.BooleanValue OPTIMIZE_MANGROVE;
    public static final ForgeConfigSpec.BooleanValue ENABLE_OPTIMIZATION;
    public static final ForgeConfigSpec.EnumValue<RenderMode> RENDER_MODE;
    public static final ForgeConfigSpec.BooleanValue OPTIMIZE_ENDER_CHESTS;
    public static final ForgeConfigSpec.BooleanValue OPTIMIZE_TRAPPED_CHESTS;
    public static final ForgeConfigSpec.IntValue MAX_RENDER_DISTANCE;
    public static ForgeConfigSpec.BooleanValue disableEntityCollisions;
    public static ForgeConfigSpec.BooleanValue optimizeEntities;
    public static final ForgeConfigSpec.BooleanValue OPTIMIZE_ENTITY_CLEANUP;
    public static ForgeConfigSpec.IntValue horizontalRange;
    public static ForgeConfigSpec.IntValue verticalRange;
    public static ForgeConfigSpec.BooleanValue ignoreDeadEntities;
    public static ForgeConfigSpec.ConfigValue<List<? extends String>> entityWhitelist;
    public static ForgeConfigSpec.BooleanValue tickRaidersInRaid;
    public static ForgeConfigSpec.BooleanValue OpenIO;
    public static ForgeConfigSpec.IntValue maxStackSize;
    public static ForgeConfigSpec.DoubleValue mergeDistance;
    public static ForgeConfigSpec.BooleanValue lockMaxedStacks;
    public static ForgeConfigSpec.IntValue listMode;
    public static ForgeConfigSpec.ConfigValue<List<? extends String>> itemList;
    public static ForgeConfigSpec.BooleanValue showStackCount;
    public static final ForgeConfigSpec.BooleanValue ENABLED;
    public static final ForgeConfigSpec.IntValue MAX_STACK_SIZE;
    public static ForgeConfigSpec.BooleanValue optimizeItems;
    public static ForgeConfigSpec.ConfigValue<List<? extends String>> itemWhitelist;
    public static final ForgeConfigSpec.IntValue MEMORY_CLEAN_INTERVAL;
    public static final ForgeConfigSpec.BooleanValue ENABLE_GC;
    public static final ForgeConfigSpec.BooleanValue MemoryLeakFix_AE2WTLibCreativeTabLeakFix;
    public static final ForgeConfigSpec.BooleanValue MemoryLeakFix_ScreenshotByteBufferLeakFix;
    public static ForgeConfigSpec.BooleanValue aggressiveChunkUnloading;
    public static ForgeConfigSpec.IntValue chunkUnloadDelay;
    public static final ForgeConfigSpec.BooleanValue CTU;
    public static final ForgeConfigSpec.IntValue CHUNKTHREADS;
    public static final ForgeConfigSpec.IntValue CHUNKIO_THREADS;
    public static final ForgeConfigSpec.BooleanValue CHUNK_REDIRECT_IO;
    public static final ForgeConfigSpec.BooleanValue CHUNk_REDIRECT_LIGHTING;
    public static final ForgeConfigSpec.IntValue CPU_QUEUE;
    public static final ForgeConfigSpec.IntValue IO_QUEUE;
    public static final ForgeConfigSpec.BooleanValue ASYNC_PARTICLES;
    public static final ForgeConfigSpec.IntValue MAX_ASYNC_OPERATIONS_PER_TICK;
    public static final ForgeConfigSpec.BooleanValue DISABLE_ASYNC_ON_ERROR;
    public static final ForgeConfigSpec.IntValue ASYNC_EVENT_TIMEOUT;
    public static final ForgeConfigSpec.BooleanValue WAIT_FOR_ASYNC_EVENTS;
    public static ForgeConfigSpec.IntValue maxCPUPro;
    public static ForgeConfigSpec.IntValue maxthreads;
    public static ForgeConfigSpec.BooleanValue FEATURE_ENABLED;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> ASYNC_EVENT_CLASS_BLACKLIST;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> ASYNC_EVENT_MOD_BLACKLIST;
    public static final ForgeConfigSpec.BooleanValue STRICT_CLASS_CHECKING;
    public static ForgeConfigSpec.BooleanValue RandomOptimizeENABLED;
    public static ForgeConfigSpec.BooleanValue Absoptimize;
    public static final ForgeConfigSpec.BooleanValue DEBUG_LOGGING;
    public static ForgeConfigSpec.BooleanValue NoOpenGLError;

    public static int getCullingDepth() {
        return (Integer)CULLING_DEPTH.get();
    }

    public static boolean useUltraCulling() {
        return (Boolean)ULTRA_CULLING.get();
    }

    public static int ultraCullingDepth() {
        return (Integer)ULTRA_DEPTH.get();
    }

    public static double ultraBackfaceThreshold() {
        return (Double)ULTRA_BACKFACE.get();
    }

    public static float getRejectionRate() {
        return ((Double)REJECTION_RATE.get()).floatValue();
    }

    public static boolean optimizeMangrove() {
        return (Boolean)OPTIMIZE_MANGROVE.get();
    }

    public static boolean useAsyncTracing() {
        return (Boolean)useAsyncTracing.get();
    }

    public static double getTraceDistance() {
        return (Double)traceDistance.get();
    }

    public static boolean useAdvancedCulling() {
        return (Boolean)ADVANCED_CULLING.get();
    }

    public static Set<String> getAsyncEventClassBlacklist() {
        return new HashSet<String>((Collection)ASYNC_EVENT_CLASS_BLACKLIST.get());
    }

    public static boolean isEnabled() {
        return (Boolean)FEATURE_ENABLED.get();
    }

    public static Set<String> getAsyncEventModBlacklist() {
        return new HashSet<String>((Collection)ASYNC_EVENT_MOD_BLACKLIST.get());
    }

    public static boolean isStrictClassCheckingEnabled() {
        return (Boolean)STRICT_CLASS_CHECKING.get();
    }

    static {
        BUILDER.push("\u51cf\u5c11\u4e0d\u5fc5\u8981\u7684\u65e5\u5fd7 | NoLog");
        NoOpenGLError = BUILDER.comment("\u53d6\u6d88OpenGL\u9519\u8bef\u65e5\u5fd7").define("disable opengl error log", true);
        BUILDER.pop();
        BUILDER.push("Math");
        RandomOptimizeENABLED = BUILDER.comment("Random\u6027\u80fd\u4f18\u5316").define("OptiRandom", true);
        Absoptimize = BUILDER.comment("Abs\u6027\u80fd\u4f18\u5316").define("OptiAbs", true);
        BUILDER.pop();
        BUILDER.push("Light");
        ENABLE_FIXED_LIGHT = BUILDER.comment("\u5149\u7167\u4f18\u5316").define("enableFixedLight", true);
        BambooLight = BUILDER.comment("\u7af9\u5b50\u5149\u7167\u4f18\u5316").define("enablebambooFixedLight", true);
        BUILDER.pop();
        BUILDER.push("Reflex");
        enableReflex = BUILDER.comment("\u542f\u7528\u7c7b\u4f3c NVIDIA Reflex \u7684\u52a8\u6001\u4f4e\u5ef6\u8fdf\u8c03\u5ea6").define("enableReflex", false);
        reflexOffsetNs = BUILDER.comment(new String[]{"Reflex \u5fae\u8c03\u7b49\u5f85\u65f6\u95f4\uff08\u7eb3\u79d2\uff09\u3002", "GPU \u5403\u4e0d\u6ee1\u5c31\u52a0\u6b63\u6570\uff1b\u961f\u5217\u5806\u79ef\u5c31\u52a0\u8d1f\u6570\u3002"}).defineInRange("reflexOffsetNs", 0L, -1000000L, 1000000L);
        MAX_FPS = BUILDER.comment("Hard framerate cap (0 = disable)").defineInRange("maxFps", 0, 0, 1000);
        reflexDebug = BUILDER.comment("\u5728\u65e5\u5fd7\u4e2d\u8f93\u51fa\u6bcf\u5e27\u7b49\u5f85\u65f6\u95f4\uff0c\u65b9\u4fbf\u8c03\u8bd5").define("reflexDebug", false);
        BUILDER.pop();
        BUILDER.push("\u7c92\u5b50\u4f18\u5316 | particle Optimization");
        ENABLE_PARTICLE_OPTIMIZATION = BUILDER.comment(new String[]{"\u542f\u7528\u7c92\u5b50\u7cfb\u7edf\u4f18\u5316", "Enable particle system optimizations"}).define("enableParticleOptimization", true);
        ENABLE_PARTICLE_LOD = BUILDER.comment(new String[]{"\u542f\u7528\u7c92\u5b50LOD\u7cfb\u7edf (Level of Detail)", "Enable particle LOD system (Level of Detail)"}).define("enableParticleLOD", true);
        LOD_DISTANCE_THRESHOLD = BUILDER.comment(new String[]{"LOD\u8ddd\u79bb\u9608\u503c (\u65b9\u5757)", "Distance threshold for LOD reduction (blocks)"}).defineInRange("lodDistanceThreshold", 16.0, 4.0, 64.0);
        LOD_REDUCTION_FACTOR = BUILDER.comment(new String[]{"LOD\u51cf\u5c11\u56e0\u5b50 (0.0-1.0)", "Reduction factor for LOD (0.0-1.0)"}).defineInRange("lodReductionFactor", 0.3, 0.0, 1.0);
        ENABLE_FIXED_TIMESTEP = BUILDER.comment(new String[]{"\u542f\u7528\u56fa\u5b9a\u65f6\u95f4\u6b65\u957f", "Enable fixed timestep for particle physics"}).define("enableFixedTimestep", true);
        FIXED_TIMESTEP_INTERVAL = BUILDER.comment(new String[]{"\u56fa\u5b9a\u65f6\u95f4\u6b65\u957f\u95f4\u9694 (\u79d2)", "Fixed timestep interval in seconds"}).defineInRange("fixedTimestepInterval", 0.05, 0.001, 0.1);
        LOD_PARTICLE_WHITELIST = BUILDER.comment(new String[]{"\u59cb\u7ec8\u5e94\u7528LOD\u7684\u7c92\u5b50\u7c7b\u578b (\u5373\u4f7f\u4e0d\u5728\u4f4e\u4f18\u5148\u7ea7\u5217\u8868)", "particle types that always use LOD (even if not low priority)"}).defineList("lodParticleWhitelist", List.of("minecraft:rain", "minecraft:smoke"), o -> o instanceof String);
        LOD_PARTICLE_BLACKLIST = BUILDER.comment(new String[]{"\u4ece\u4e0d\u5e94\u7528LOD\u7684\u7c92\u5b50\u7c7b\u578b", "particle types that never use LOD"}).defineList("lodParticleBlacklist", List.of("minecraft:portal", "minecraft:enchant"), o -> o instanceof String);
        BUILDER.pop();
        BUILDER.push("\u9ad8\u7248\u672cmc\u4f18\u5316\u79fb\u690d");
        FIX_PEARL_LEAK = BUILDER.define("fixPearlChunkLeak", true);
        FIX_PROJECTILE_LERP = BUILDER.define("fixProjectileInterpolation", true);
        BUILDER.pop();
        BUILDER.push("\u6e32\u67d3\u4f18\u5316 | Rendering Optimization");
        skipOutlineWhenNoGlowing = BUILDER.comment("Skip outline rendering when no glowing entities are in view").define("skipOutlineWhenNoGlowing", true);
        fpsoo = BUILDER.comment("\u51cf\u5c11\u6e32\u67d3\u5ef6\u8fdf\uff0c\u628a\u300c\u628a\u6700\u7ec8\u753b\u9762\u4ece MC \u7684\u79bb\u5c4f FBO\uff08MainTarget\uff09\u62f7\u8d1d\u5230\u5c4f\u5e55\u300d\u8fd9\u4e00\u6b65\uff0c\u7531\u201c\u753b\u4e00\u4e2a\u5168\u5c4f\u4e09\u89d2\u5f62\u201d\u6539\u6210\u4e86\u201c\u4e00\u6b21 GPU \u5185\u90e8\u7684 glBlitFramebuffer \u6307\u4ee4\u201d").define("fpsoo", true);
        BUILDER.pop();
        BUILDER.push("chest_optimization");
        ENABLE_OPTIMIZATION = BUILDER.comment("Enable chest rendering optimization").define("enableOptimization", true);
        RENDER_MODE = BUILDER.comment("Rendering mode").defineEnum("renderMode", (Enum)RenderMode.SIMPLE);
        OPTIMIZE_ENDER_CHESTS = BUILDER.comment("Optimize ender chests").define("optimizeEnderChests", true);
        OPTIMIZE_TRAPPED_CHESTS = BUILDER.comment("Optimize trapped chests").define("optimizeTrappedChests", false);
        MAX_RENDER_DISTANCE = BUILDER.comment("Max render distance in chunks").defineInRange("maxRenderDistance", 32, 1, 128);
        BUILDER.pop();
        BUILDER.push("\u9ad8\u7ea7\u5254\u9664 | Advanced Culling");
        ENABLEDCULL = BUILDER.comment(new String[]{"\u542f\u7528\u6811\u53f6\u6e32\u67d3\u4f18\u5316", "Enable leaf rendering optimizations"}).define("enabled", true);
        CULLING_DEPTH = BUILDER.comment(new String[]{"\u5254\u9664\u6df1\u5ea6 (1-5)\uff0c\u503c\u8d8a\u9ad8\u6027\u80fd\u8d8a\u597d\u4f46\u53ef\u80fd\u5bfc\u81f4\u89c6\u89c9\u5f02\u5e38", "Culling depth (1-5), Higher values = better performance but may cause visual artifacts"}).defineInRange("cullingDepth", 5, 1, 5);
        REJECTION_RATE = BUILDER.comment(new String[]{"\u968f\u673a\u5254\u9664\u7387 (0.0-1.0)\uff0c\u9632\u6b62\u53ef\u89c1\u7684\u5254\u9664\u6a21\u5f0f", "FastRandom rejection rate (0.0-1.0), Prevents visible culling patterns"}).defineInRange("rejectionRate", 0.65, 0.0, 1.0);
        BUILDER.push("\u8d85\u6fc0\u8fdb\u5254\u9664 | Ultra Culling");
        ULTRA_CULLING = BUILDER.comment(new String[]{"\u542f\u7528\u8d85\u6fc0\u8fdb\u5254\u9664\uff08\u5bf9\u6240\u6709\u65b9\u5757/\u5b9e\u4f53\u751f\u6548\uff09", "Enable ultra-aggressive culling (affects all blocks/entities)"}).define("ultraCulling", true);
        ULTRA_DEPTH = BUILDER.comment(new String[]{"\u5254\u9664\u6df1\u5ea6 (1-4)\uff0c\u503c\u8d8a\u5927\u5254\u9664\u8d8a\u6fc0\u8fdb\u4f46\u53ef\u80fd\u51fa\u73b0bug", "Culling depth (1-4), Higher values = more aggressive culling but may cause bugs"}).defineInRange("ultraDepth", 5, 1, 4);
        ULTRA_BACKFACE = BUILDER.comment(new String[]{"\u4ec5\u5254\u9664\u80cc\u5411\u73a9\u5bb6\u7684\u9762\uff08\u9632\u6b62\u6b63\u9762\u6d88\u5931\uff09\uff0c\u503c\u8303\u56f40.0-1.0", "Only cull backfaces (prevent front-face disappearance), value range 0.0-1.0"}).defineInRange("ultraBackfaceOnly", 0.95, 0.0, 1.0);
        BUILDER.pop();
        ADVANCED_CULLING = BUILDER.comment(new String[]{"\u4f7f\u7528\u9ad8\u7ea7\u5254\u9664\u7b97\u6cd5\uff0c\u66f4\u7cbe\u786e\u4f46\u7a0d\u6162", "Use advanced culling algorithm, More precise but slightly slower"}).define("advancedCulling", true);
        BUILDER.pop();
        BUILDER.push("\u8def\u5f84\u8ffd\u8e2a | Path Tracing");
        useAsyncTracing = BUILDER.comment(new String[]{"\u542f\u7528\u5f02\u6b65\u8def\u5f84\u8ffd\u8e2a\u8fdb\u884c\u5254\u9664", "Enable async path tracing for culling"}).define("asyncTracing", true);
        tracingThreads = BUILDER.comment(new String[]{"\u8def\u5f84\u8ffd\u8e2a\u7ebf\u7a0b\u6570 (1-8)", "Number of threads for path tracing (1-8)"}).defineInRange("tracingThreads", 4, 1, 8);
        traceDistance = BUILDER.comment(new String[]{"\u6700\u5927\u8ffd\u8e2a\u8ddd\u79bb\uff08\u65b9\u5757\uff09", "Max tracing distance in blocks"}).defineInRange("traceDistance", 6.0, 1.0, 16.0);
        fallbackDistance = BUILDER.comment(new String[]{"\u56de\u9000\u7b80\u5355\u5254\u9664\u8ddd\u79bb\uff08\u65b9\u5757\uff09", "Fallback simple culling distance in blocks"}).defineInRange("fallbackDistance", 16.0, 4.0, 32.0);
        BUILDER.pop();
        BUILDER.push("\u6811\u53f6\u4f18\u5316 | Leaf Optimization");
        useAdvancedLeafCulling = BUILDER.comment(new String[]{"\u4f7f\u7528\u9ad8\u7ea7\u6811\u53f6\u5254\u9664\u7b97\u6cd5", "Use advanced leaf culling algorithm"}).define("advancedLeafCulling", true);
        minLeafConnections = BUILDER.comment(new String[]{"\u7b80\u5355\u5254\u9664\u6240\u9700\u7684\u6700\u5c0f\u6811\u53f6\u8fde\u63a5\u6570 (1-6)", "Minimum connected leaves for simple culling (1-6)"}).defineInRange("minConnections", 2, 1, 6);
        OPTIMIZE_MANGROVE = BUILDER.comment(new String[]{"\u542f\u7528\u7ea2\u6811\u6797\u6839\u4f18\u5316", "Enable mangrove roots optimization"}).define("optimizeMangrove", true);
        BUILDER.pop();
        BUILDER.push("\u975e\u6d3b\u52a8\u72b6\u6001\u4f18\u5316 | Inactive Optimization");
        REDUCE_FPS_WHEN_INACTIVE = BUILDER.comment(new String[]{"\u7a97\u53e3\u975e\u6d3b\u52a8\u65f6\u964d\u4f4eFPS", "Enable FPS reduction when window is inactive"}).define("reduceFpsWhenInactive", false);
        INACTIVE_FPS_LIMIT = BUILDER.comment(new String[]{"\u975e\u6d3b\u52a8\u72b6\u6001FPS\u9650\u5236 (5-60)", "FPS limit when window is inactive (5-60)"}).defineInRange("inactiveFpsLimit", 10, 5, 60);
        REDUCE_RENDER_DISTANCE_WHEN_INACTIVE = BUILDER.comment(new String[]{"\u7a97\u53e3\u975e\u6d3b\u52a8\u65f6\u964d\u4f4e\u6e32\u67d3\u8ddd\u79bb", "Enable render distance reduction when window is inactive"}).define("reduceRenderDistanceWhenInactive", false);
        INACTIVE_RENDER_DISTANCE = BUILDER.comment(new String[]{"\u975e\u6d3b\u52a8\u72b6\u6001\u6e32\u67d3\u8ddd\u79bb (2-12)", "Render distance when window is inactive (2-12)"}).defineInRange("inactiveRenderDistance", 2, 2, 12);
        BUILDER.pop();
        BUILDER.comment("\u5b9e\u4f53\u4f18\u5316 | Entity Optimization").push("entity_optimization");
        disableEntityCollisions = BUILDER.comment(new String[]{"\u4f18\u5316\u5b9e\u4f53\u78b0\u649e\u68c0\u6d4b", "Optimize entity collision detection"}).define("disableEntityCollisions", true);
        BUILDER.push("\u5b9e\u4f53Tick\u4f18\u5316 | Entity Tick Optimization");
        optimizeEntities = BUILDER.comment(new String[]{"\u542f\u7528\u5b9e\u4f53tick\u4f18\u5316", "Enable entity tick optimization"}).define("optimizeEntities", true);
        horizontalRange = BUILDER.comment(new String[]{"\u6c34\u5e73\u68c0\u6d4b\u8303\u56f4(\u65b9\u5757)", "Horizontal detection range (blocks)"}).defineInRange("horizontalRange", 64, 1, 256);
        verticalRange = BUILDER.comment(new String[]{"\u5782\u76f4\u68c0\u6d4b\u8303\u56f4(\u65b9\u5757)", "Vertical detection range (blocks)"}).defineInRange("verticalRange", 32, 1, 256);
        ignoreDeadEntities = BUILDER.comment(new String[]{"\u5ffd\u7565\u5df2\u6b7b\u4ea1\u7684\u5b9e\u4f53", "Ignore dead entities"}).define("ignoreDeadEntities", false);
        BUILDER.pop();
        BUILDER.push("\u5b9e\u4f53\u767d\u540d\u5355 | Entity Whitelist");
        OPTIMIZE_ENTITY_CLEANUP = BUILDER.comment(new String[]{"\u542f\u7528\u6b7b\u4ea1\u5b9e\u4f53\u6e05\u7406", "Enable dead entity cleanup"}).define("entityCleanup", true);
        entityWhitelist = BUILDER.comment(new String[]{"\u5b9e\u4f53\u767d\u540d\u5355\uff08\u59cb\u7ec8\u4e0d\u4f18\u5316\uff09", "Entity whitelist (always optimized)"}).defineList("entityWhitelist", List.of("minecraft:ender_dragon"), o -> true);
        BUILDER.pop();
        BUILDER.push("\u88ad\u51fb\u4e8b\u4ef6 | Raid Events");
        tickRaidersInRaid = BUILDER.comment(new String[]{"\u5728\u88ad\u51fb\u4e2d\u4fdd\u6301\u88ad\u51fb\u8005tick", "Keep raider ticking during raids"}).define("tickRaidersInRaid", true);
        BUILDER.pop();
        BUILDER.pop();
        BUILDER.comment("\u7269\u54c1\u4f18\u5316 | Item Optimization").push("item_optimization");
        OpenIO = BUILDER.comment(new String[]{"\u542f\u7528\u7269\u54c1\u4f18\u5316\u7cfb\u7edf", "Enable item optimization system"}).define("OpenIO", true);
        BUILDER.push("\u5806\u53e0\u5408\u5e76 | Stack Merging");
        maxStackSize = BUILDER.comment(new String[]{"\u5408\u5e76\u7269\u54c1\u7684\u6700\u5927\u5806\u53e0\u6570\u91cf\uff08-1\u8868\u793a\u65e0\u9650\u5236\uff09", "Maximum stack size for merged items (-1 = no limit)"}).defineInRange("maxStackSize", -1, -1, Integer.MAX_VALUE);
        mergeDistance = BUILDER.comment(new String[]{"\u7269\u54c1\u5408\u5e76\u68c0\u6d4b\u534a\u5f84\uff08\u65b9\u5757\uff09", "Item merge detection radius in blocks"}).defineInRange("mergeDistance", 1.5, 0.1, 10.0);
        showStackCount = BUILDER.comment(new String[]{"\u5728\u5408\u5e76\u540e\u7684\u7269\u54c1\u4e0a\u663e\u793a\u5806\u53e0\u6570\u91cf", "Show stack count on merged items"}).define("showStackCount", true);
        lockMaxedStacks = BUILDER.comment(new String[]{"\u5f53\u7269\u54c1\u5806\u53e0\u8fbe\u5230\u6700\u5927\u65f6\u9501\u5b9a\uff0c\u4e0d\u518d\u53c2\u4e0e\u5408\u5e76", "Lock stacks that have reached the maximum size to prevent further merging"}).define("lockMaxedStacks", true);
        BUILDER.pop();
        BUILDER.push("\u81ea\u5b9a\u4e49\u5806\u53e0 | Custom Stack Size");
        ENABLED = BUILDER.comment(new String[]{"\u542f\u7528\u81ea\u5b9a\u4e49\u5806\u53e0\u5927\u5c0f-\u8fd9\u91cc\u6539\u4e86\u51fa\u95ee\u9898\u7684\u6539\u56de\u53bb\uff0c\u8bb0\u4f4f\u8fd9\u53e5\u8bdd\uff01\u7279\u522b\u662f\u79d1\u6280\u670d\u8150\u7af9\uff01", "Enable custom stack sizes"}).define("enabled", false);
        MAX_STACK_SIZE = BUILDER.comment(new String[]{"\u6700\u5927\u7269\u54c1\u5806\u53e0\u5927\u5c0f (1-9999)", "Maximum item stack size (1-9999)"}).defineInRange("maxStackSize", 64, 1, 9999);
        BUILDER.pop();
        BUILDER.push("\u7269\u54c1\u5217\u8868 | Item Lists");
        listMode = BUILDER.comment(new String[]{"0: \u7981\u7528 1: \u767d\u540d\u5355\u6a21\u5f0f 2: \u9ed1\u540d\u5355\u6a21\u5f0f", "0: Disabled, 1: Whitelist, 2: Blacklist"}).defineInRange("listMode", 0, 0, 2);
        itemList = BUILDER.comment(new String[]{"\u767d\u540d\u5355/\u9ed1\u540d\u5355\u4e2d\u7684\u7269\u54c1\u6ce8\u518c\u540d\u5217\u8868", "Item registry names for whitelist/blacklist"}).defineList("itemList", Collections.emptyList(), o -> o instanceof String);
        BUILDER.pop();
        BUILDER.push("\u7269\u54c1\u5b9e\u4f53 | Item Entities");
        optimizeItems = BUILDER.comment(new String[]{"\u4f18\u5316\u7269\u54c1\u5b9e\u4f53tick", "Optimize item entity ticking"}).define("optimizeItems", false);
        itemWhitelist = BUILDER.comment(new String[]{"\u7269\u54c1\u5b9e\u4f53\u767d\u540d\u5355", "Item entity whitelist"}).defineList("itemWhitelist", List.of("minecraft:diamond"), o -> true);
        BUILDER.pop();
        BUILDER.pop();
        BUILDER.comment("\u5185\u5b58\u4f18\u5316 | Memory Optimization").push("memory_optimization");
        MEMORY_CLEAN_INTERVAL = BUILDER.comment(new String[]{"\u5185\u5b58\u6e05\u7406\u95f4\u9694(\u79d2)", "Memory cleanup interval (seconds)"}).defineInRange("cleanInterval", 600, 60, 3600);
        ENABLE_GC = BUILDER.comment(new String[]{"\u6e05\u7406\u65f6\u89e6\u53d1\u5783\u573e\u56de\u6536", "Trigger garbage collection during cleanup"}).define("enableGC", false);
        MemoryLeakFix_AE2WTLibCreativeTabLeakFix = BUILDER.comment(new String[]{"\u5185\u5b58\u6cc4\u6f0f\u4fee\u590d_AE2WTLibCreativeTabLeakFix", "MemoryLeakFix_AE2WTLib"}).define("enablememoryleakfixae2", true);
        MemoryLeakFix_ScreenshotByteBufferLeakFix = BUILDER.comment(new String[]{"\u5185\u5b58\u6cc4\u6f0f\u4fee\u590d_ScreenshotByteBufferLeakFix", "MemoryLeakFix_ScreenshotByteBufferLeakFix"}).define("enablememoryleakfixScreenshotByteBufferLeakFix", true);
        BUILDER.pop();
        BUILDER.comment("\u533a\u5757\u4f18\u5316 | Chunk Optimization").push("chunk_optimization");
        aggressiveChunkUnloading = BUILDER.comment(new String[]{"\u4e3b\u52a8\u5378\u8f7d\u975e\u6d3b\u52a8\u533a\u5757", "Aggressively unload inactive chunks"}).define("aggressiveChunkUnloading", false);
        chunkUnloadDelay = BUILDER.comment(new String[]{"\u533a\u5757\u5378\u8f7d\u5ef6\u8fdf (\u79d2)", "Chunk unload delay (seconds)"}).defineInRange("chunkUnloadDelay", 60, 10, 600);
        CTU = BUILDER.comment("\u662f\u5426\u542f\u7528\u4ee5\u4e0b\u529f\u80fd-\u8bf7\u52ff\u5728\u5df2\u7ecf\u542f\u52a8\u6e38\u620f\u5e76\u4e14\u5f00\u542f\u6b64\u529f\u80fd\u65f6\u5173\u95ed\u5426\u5219\u4f1a\u5bfc\u81f4\u610f\u60f3\u4e0d\u5230\u7684\u540e\u679c").define("Chunk++", true);
        CHUNKTHREADS = BUILDER.comment("\u7ebf\u7a0b\u6570").defineInRange("chunkcputhreads", 2, 2, 128);
        CHUNKIO_THREADS = BUILDER.comment("IO\u7ebf\u7a0b").defineInRange("chunkioThreads", 4, 2, 256);
        CHUNK_REDIRECT_IO = BUILDER.comment("\u533a\u5757\u4f18\u5316-ct").define("chunkoptimizeIo", true);
        CPU_QUEUE = BUILDER.comment("CPU\u961f\u5217\u6700\u5927\u9650\u5236").defineInRange("cpu_queue", 3072, 1536, 8192);
        IO_QUEUE = BUILDER.comment("IO\u961f\u5217\u6700\u5927\u9650\u5236").defineInRange("io_queue", 1536, 1536, 8192);
        CHUNk_REDIRECT_LIGHTING = BUILDER.comment("\u533a\u5757\u4f18\u5316-l-Beta").define("chunk-l-beta", true);
        BUILDER.pop();
        BUILDER.comment("\u5f02\u6b65\u4f18\u5316 | Async Optimization").push("async_optimization");
        ASYNC_PARTICLES = BUILDER.comment(new String[]{"\u542f\u7528\u5f02\u6b65\u7c92\u5b50\u5904\u7406", "Enable asynchronous particle processing"}).define("asyncParticles", true);
        MAX_ASYNC_OPERATIONS_PER_TICK = BUILDER.comment(new String[]{"\u6bcftick\u6700\u5927\u5f02\u6b65\u64cd\u4f5c\u6570", "Max async operations processed per tick"}).defineInRange("maxAsyncOpsPerTick", 1000, 100, 10000);
        DISABLE_ASYNC_ON_ERROR = BUILDER.comment(new String[]{"\u51fa\u9519\u540e\u7981\u7528\u8be5\u4e8b\u4ef6\u7c7b\u578b\u7684\u5f02\u6b65\u5904\u7406", "Disable async for event type after errors"}).define("disableAsyncOnError", true);
        ASYNC_EVENT_TIMEOUT = BUILDER.comment(new String[]{"\u5f02\u6b65\u4e8b\u4ef6\u8d85\u65f6\u65f6\u95f4(\u79d2)", "Timeout in seconds for async events"}).defineInRange("asyncEventTimeout", 2, 1, 10);
        WAIT_FOR_ASYNC_EVENTS = BUILDER.comment(new String[]{"\u7b49\u5f85\u5f02\u6b65\u4e8b\u4ef6\u5b8c\u6210", "Wait for async events to complete"}).define("waitForAsyncEvents", false);
        BUILDER.push("\u7ebf\u7a0b\u914d\u7f6e | Thread Configuration");
        maxCPUPro = BUILDER.comment(new String[]{"\u5f02\u6b65\u7cfb\u7edf\u6700\u5927CPU\u6838\u5fc3\u6570", "Max CPU Cores for async system"}).defineInRange("maxCPUPro", 8, 2, 128);
        maxthreads = BUILDER.comment(new String[]{"\u6700\u5927\u7ebf\u7a0b\u6570", "Max Threads for general async operations"}).defineInRange("maxthreads", 8, 2, 256);
        BUILDER.pop();
        BUILDER.pop();
        BUILDER.comment("\u4e8b\u4ef6\u7cfb\u7edf | Event System").push("event_system");
        FEATURE_ENABLED = BUILDER.comment(new String[]{"\u542f\u7528\u9ad8\u6027\u80fd\u5f02\u6b65\u4e8b\u4ef6\u529f\u80fd", "Enable high-performance async event system"}).define("featureEnabled", true);
        ASYNC_EVENT_CLASS_BLACKLIST = BUILDER.comment(new String[]{"\u4e0d\u5e94\u5f02\u6b65\u5904\u7406\u7684\u4e8b\u4ef6\u7c7b\u5217\u8868\uff08\u652f\u6301\u901a\u914d\u7b26\uff09", "Event classes that should NOT be processed asynchronously (supports wildcards)"}).defineList("classBlacklist", List.of("net.minecraftforge.event.TickEvent", "net.minecraftforge.event.level.LevelTickEvent", "net.minecraftforge.event.entity.living.*"), o -> o instanceof String);
        ASYNC_EVENT_MOD_BLACKLIST = BUILDER.comment(new String[]{"\u4e0d\u5e94\u5f02\u6b65\u5904\u7406\u7684\u6a21\u7ec4ID\u5217\u8868", "Mod IDs whose events should NOT be processed asynchronously"}).defineList("modBlacklist", Collections.emptyList(), o -> o instanceof String);
        STRICT_CLASS_CHECKING = BUILDER.comment(new String[]{"\u542f\u7528\u4e25\u683c\u7684\u7c7b\u5b58\u5728\u68c0\u67e5\uff08\u63a8\u8350\u5f00\u542f\u4ee5\u786e\u4fdd\u7a33\u5b9a\u6027\uff09", "Enable strict class existence checking (disable for stability)"}).define("strictClassChecking", true);
        BUILDER.pop();
        BUILDER.comment("\u8c03\u8bd5\u9009\u9879 | Debug Options").push("debug");
        DEBUG_LOGGING = BUILDER.comment(new String[]{"\u542f\u7528\u8c03\u8bd5\u65e5\u5fd7", "Enable debug logging"}).define("debug", false);
        BUILDER.pop();
        SPEC = BUILDER.build();
    }

    public static enum RenderMode {
        SIMPLE,
        VANILLA,
        SEMI_COMPLEX;

    }
}

