/*
 * Decompiled with CFR 0.152.
 */
package net.carbonmc.graphene.mixin.chunk.newthing;

import com.mojang.datafixers.util.Either;
import java.util.concurrent.CompletableFuture;
import net.carbonmc.graphene.config.CoolConfig;
import net.carbonmc.graphene.optimization.chunk.ChunkOptif;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.LevelChunk;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ChunkMap.class})
public abstract class MixinChunkMap {
    @Inject(method={"scheduleChunkGeneration"}, at={@At(value="HEAD")})
    private void onGenerationTaskStart(ChunkHolder holder, ChunkStatus status, CallbackInfoReturnable<CompletableFuture<Either<ChunkAccess, ChunkHolder.ChunkLoadingFailure>>> cir) {
        if (((Boolean)CoolConfig.CTU.get()).booleanValue()) {
            ChunkOptif.go(ChunkOptif.toid(holder.m_140092_()));
        }
    }

    @Inject(method={"scheduleChunkGeneration"}, at={@At(value="RETURN")})
    private void onGenerationTaskComplete(ChunkHolder holder, ChunkStatus status, CallbackInfoReturnable<CompletableFuture<Either<ChunkAccess, ChunkHolder.ChunkLoadingFailure>>> cir) {
        if (((Boolean)CoolConfig.CTU.get()).booleanValue()) {
            ChunkOptif.to();
        }
    }

    @Inject(method={"prepareEntityTickingChunk"}, at={@At(value="HEAD")})
    private void onFollowupTaskStart(ChunkHolder holder, CallbackInfoReturnable<CompletableFuture<LevelChunk>> cir) {
        if (((Boolean)CoolConfig.CTU.get()).booleanValue()) {
            ChunkOptif.go(ChunkOptif.toid(holder.m_140092_()));
        }
    }

    @Inject(method={"prepareEntityTickingChunk"}, at={@At(value="RETURN")})
    private void onFollowupTaskComplete(ChunkHolder holder, CallbackInfoReturnable<CompletableFuture<LevelChunk>> cir) {
        if (((Boolean)CoolConfig.CTU.get()).booleanValue()) {
            ChunkOptif.to();
        }
    }

    @Inject(method={"scheduleChunkGeneration"}, at={@At(value="TAIL")})
    private void onGenerationTail(ChunkHolder holder, ChunkStatus status, CallbackInfoReturnable<CompletableFuture<Either<ChunkAccess, ChunkHolder.ChunkLoadingFailure>>> cir) {
        if (((Boolean)CoolConfig.CTU.get()).booleanValue()) {
            ChunkOptif.cleanupThreadState();
        }
    }

    @Inject(method={"prepareEntityTickingChunk"}, at={@At(value="TAIL")})
    private void onEntityTickingTail(ChunkHolder holder, CallbackInfoReturnable<CompletableFuture<LevelChunk>> cir) {
        if (((Boolean)CoolConfig.CTU.get()).booleanValue()) {
            ChunkOptif.cleanupThreadState();
        }
    }

    @Inject(method={"getVisibleChunkIfPresent"}, at={@At(value="HEAD")})
    private void onVisibleChunkAccess(long pos, CallbackInfoReturnable<ChunkHolder> cir) {
        if (((Boolean)CoolConfig.CTU.get()).booleanValue()) {
            ChunkOptif.go(ChunkOptif.toid(new ChunkPos(pos)));
        }
    }

    @Inject(method={"getVisibleChunkIfPresent"}, at={@At(value="RETURN")})
    private void onVisibleChunkAccessComplete(long pos, CallbackInfoReturnable<ChunkHolder> cir) {
        if (((Boolean)CoolConfig.CTU.get()).booleanValue()) {
            ChunkOptif.to();
        }
    }

    @Inject(method={"getVisibleChunkIfPresent"}, at={@At(value="TAIL")})
    private void onVisibleChunkTail(long pos, CallbackInfoReturnable<ChunkHolder> cir) {
        if (((Boolean)CoolConfig.CTU.get()).booleanValue()) {
            ChunkOptif.cleanupThreadState();
        }
    }

    @Inject(method={"onFullChunkStatusChange"}, at={@At(value="HEAD")})
    private void onFullChunkStatusChange(ChunkPos p_287612_, FullChunkStatus p_287685_, CallbackInfo ci) {
        if (((Boolean)CoolConfig.CTU.get()).booleanValue()) {
            ChunkOptif.go(ChunkOptif.toid(p_287612_));
        }
    }

    @Inject(method={"onFullChunkStatusChange"}, at={@At(value="RETURN")})
    private void onFullChunkStatusChangeComplete(ChunkPos p_287612_, FullChunkStatus p_287685_, CallbackInfo ci) {
        if (((Boolean)CoolConfig.CTU.get()).booleanValue()) {
            ChunkOptif.to();
        }
    }

    @Inject(method={"onFullChunkStatusChange"}, at={@At(value="TAIL")})
    private void onFullChunkStatusTail(ChunkPos p_287612_, FullChunkStatus p_287685_, CallbackInfo ci) {
        if (((Boolean)CoolConfig.CTU.get()).booleanValue()) {
            ChunkOptif.cleanupThreadState();
        }
    }

    @Inject(method={"getUpdatingChunkIfPresent"}, at={@At(value="HEAD")})
    private void onUpdatingChunkAccess(long pos, CallbackInfoReturnable<ChunkHolder> cir) {
        if (((Boolean)CoolConfig.CTU.get()).booleanValue()) {
            ChunkOptif.go(ChunkOptif.toid(new ChunkPos(pos)));
        }
    }

    @Inject(method={"getUpdatingChunkIfPresent"}, at={@At(value="RETURN")})
    private void onUpdatingChunkAccessComplete(long pos, CallbackInfoReturnable<ChunkHolder> cir) {
        if (((Boolean)CoolConfig.CTU.get()).booleanValue()) {
            ChunkOptif.to();
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void onChunkMapTick(CallbackInfo ci) {
        if (((Boolean)CoolConfig.CTU.get()).booleanValue()) {
            ChunkOptif.validateAndRepair();
        }
    }
}

