/*
 * Decompiled with CFR 0.152.
 */
package net.carbonmc.graphene.optimization.math.abs;

import java.lang.reflect.Field;
import sun.misc.Unsafe;

public final class FastAbs {
    private static final FastAbs INSTANCE = new FastAbs();
    private static final Unsafe UNSAFE;
    private static final long INT_ARRAY_OFFSET;
    private static final long FLOAT_ARRAY_OFFSET;

    private FastAbs() {
    }

    public static FastAbs getInstance() {
        return INSTANCE;
    }

    public static int abs(int x) {
        int mask = x >> 31;
        return x + mask ^ mask;
    }

    public static float abs(float x) {
        return Float.intBitsToFloat(Float.floatToRawIntBits(x) & Integer.MAX_VALUE);
    }

    static {
        Unsafe unsafeInstance = null;
        long intArrayOffset = 0L;
        long floatArrayOffset = 0L;
        try {
            Field field = Unsafe.class.getDeclaredField("theUnsafe");
            field.setAccessible(true);
            unsafeInstance = (Unsafe)field.get(null);
            intArrayOffset = unsafeInstance.arrayBaseOffset(int[].class);
            floatArrayOffset = unsafeInstance.arrayBaseOffset(float[].class);
        }
        catch (Exception e) {
            System.err.println("Unsafe initialization failed");
        }
        UNSAFE = unsafeInstance;
        INT_ARRAY_OFFSET = intArrayOffset;
        FLOAT_ARRAY_OFFSET = floatArrayOffset;
    }
}

