/*
 * Decompiled with CFR 0.152.
 */
package net.carbonmc.graphene;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.collect.Queues;
import com.mojang.brigadier.CommandDispatcher;
import java.io.File;
import java.lang.ref.Cleaner;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import net.carbonmc.graphene.async.AsyncSystemInitializer;
import net.carbonmc.graphene.async.chunk.ChunkPool;
import net.carbonmc.graphene.client.GrapheneClient;
import net.carbonmc.graphene.command.KillMobsCommand;
import net.carbonmc.graphene.config.CoolConfig;
import net.carbonmc.graphene.event.AsyncEventSystem;
import net.carbonmc.graphene.event.ModEventProcessor;
import net.carbonmc.graphene.events.ModEventHandlers;
import net.carbonmc.graphene.gl.CleanerRunnable;
import net.carbonmc.graphene.particles.AsyncParticleHandler;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.IExtensionPoint;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.launch.MixinBootstrap;

@Mod(value="graphene")
public class Graphene {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final String MODID = "graphene";
    public static final String VERSION = "1.7.0";
    public static File Graphene_EVENTS_LOG = new File("log/graphene-event-debug.log");
    public static volatile boolean OpenC = false;
    private ExecutorService executorService;
    private static final ConcurrentLinkedQueue<CleanerRunnable> PENDING = Queues.newConcurrentLinkedQueue();
    private static final Cleaner CLEANER = Cleaner.create();
    public static final ChunkPool CKU = new ChunkPool();
    public static final Cache<ChunkPos, int[]> CHUNK_CACHE = Caffeine.newBuilder().maximumSize(1024L).expireAfterAccess(5L, TimeUnit.MINUTES).build();

    public Graphene() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        IEventBus forgeEventBus = MinecraftForge.EVENT_BUS;
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)CoolConfig.SPEC);
        forgeEventBus.register((Object)this);
        modEventBus.addListener(this::setup);
        MixinBootstrap.init();
        modEventBus.addListener(this::commonSetup);
        MinecraftForge.EVENT_BUS.addListener(this::onServerStarted);
        MinecraftForge.EVENT_BUS.addListener(this::onServerStopping);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            MinecraftForge.EVENT_BUS.addListener(evt -> {
                if (evt.phase == TickEvent.Phase.END) {
                    this.onEndClientTick();
                }
            });
        }
        ModEventHandlers.register(modEventBus, forgeEventBus);
        modEventBus.addListener(AsyncSystemInitializer::init);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            AsyncEventSystem.shutdown();
            AsyncParticleHandler.shutdown();
        }));
        LOGGER.info("Initializing Graphene MOD v{}", (Object)VERSION);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> GrapheneClient::init);
        ModLoadingContext.get().registerExtensionPoint(IExtensionPoint.DisplayTest.class, () -> new IExtensionPoint.DisplayTest(() -> "ANY", (remote, isServer) -> true));
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        CKU.a();
        int processors = Runtime.getRuntime().availableProcessors();
        this.executorService = Executors.newWorkStealingPool(Math.max(2, processors / 2));
        LOGGER.info("Registered async executor for Optimized Abs with {} threads", (Object)((ForkJoinPool)this.executorService).getParallelism());
    }

    private void onServerStarted(ServerStartedEvent event) {
        CHUNK_CACHE.invalidateAll();
        CKU.v();
        OpenC = true;
    }

    private void onEndClientTick() {
        int drained = 0;
        while (!PENDING.isEmpty() && drained++ < 16) {
            CleanerRunnable r = PENDING.poll();
            if (r == null) continue;
            r.run();
        }
    }

    private void onServerStopping(ServerStoppingEvent event) {
        CKU.af();
        OpenC = false;
        if (this.executorService != null) {
            try {
                this.executorService.shutdown();
                if (!this.executorService.awaitTermination(5L, TimeUnit.SECONDS)) {
                    this.executorService.shutdownNow();
                }
                LOGGER.info("Async executor for Optimized Abs shutdown complete");
            }
            catch (InterruptedException e) {
                this.executorService.shutdownNow();
                Thread.currentThread().interrupt();
            }
        }
    }

    private void setup(FMLCommonSetupEvent event) {
        LOGGER.info("Graphene Mod \u521d\u59cb\u5316\u5b8c\u6210");
        LOGGER.info("Graphene-CarbonMC\u5b98\u65b9QQ\u7fa4\uff1a372378451");
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        event.enqueueWork(() -> {
            AsyncEventSystem.initialize();
            ModEventProcessor.processModEvents();
        });
    }

    @SubscribeEvent
    public void onRegisterCommands(RegisterCommandsEvent event) {
        KillMobsCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }
}

