/*
 * Decompiled with CFR 0.152.
 */
package net.carbonmc.graphene.async;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import net.carbonmc.graphene.async.entity.AsyncAIManager;
import net.carbonmc.graphene.async.entity.AsyncCollisionSystem;
import net.carbonmc.graphene.async.player.AsyncPlayerData;
import net.carbonmc.graphene.async.redstone.AsyncRedstone;
import net.carbonmc.graphene.async.resources.AsyncResourceLoader;
import net.carbonmc.graphene.async.sound.AsyncSoundSystem;
import net.carbonmc.graphene.async.world.StructureGenAsync;
import net.carbonmc.graphene.config.CoolConfig;
import net.carbonmc.graphene.event.AsyncHandler;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@AsyncHandler
public class AsyncSystemInitializer {
    private static final Logger LOGGER = LogManager.getLogger((String)"AsyncSystemInitializer");
    private static final AtomicBoolean initialized = new AtomicBoolean(false);
    private static final AtomicBoolean shutdownInProgress = new AtomicBoolean(false);
    private static ExecutorService defaultThreadPool;
    private static ExecutorService ioThreadPool;
    private static ExecutorService computationThreadPool;

    public static void init(FMLCommonSetupEvent event) {
        if (!initialized.compareAndSet(false, true)) {
            LOGGER.warn("Async system already initialized");
            return;
        }
        try {
            defaultThreadPool = AsyncSystemInitializer.createThreadPool("Async-Default", 4);
            ioThreadPool = AsyncSystemInitializer.createThreadPool("Async-IO", 2);
            computationThreadPool = AsyncSystemInitializer.createThreadPool("Async-Compute", Runtime.getRuntime().availableProcessors() / 2);
            AsyncSystemInitializer.safeInit(StructureGenAsync::init, "StructureGenAsync");
            AsyncSystemInitializer.safeInit(AsyncAIManager::init, "AsyncAIManager");
            AsyncSystemInitializer.safeInit(AsyncCollisionSystem::init, "AsyncCollisionSystem");
            AsyncSystemInitializer.safeInit(AsyncPlayerData::init, "AsyncPlayerData");
            AsyncSystemInitializer.safeInit(AsyncResourceLoader::init, "AsyncResourceLoader");
            AsyncSystemInitializer.safeInit(AsyncRedstone::init, "AsyncRedstone");
            AsyncSystemInitializer.safeInit(AsyncSoundSystem::init, "AsyncSoundSystem");
            AsyncSystemInitializer.registerEventHandlers();
            Runtime.getRuntime().addShutdownHook(new Thread(AsyncSystemInitializer::shutdown, "AsyncSystem-ShutdownHook"));
            if (((Boolean)CoolConfig.DEBUG_LOGGING.get()).booleanValue()) {
                LOGGER.info("Async system initialized successfully");
            }
        }
        catch (Exception e) {
            if (((Boolean)CoolConfig.DEBUG_LOGGING.get()).booleanValue()) {
                LOGGER.error("Failed to initialize async system", (Throwable)e);
            }
            AsyncSystemInitializer.shutdown();
            throw new RuntimeException("Async system initialization failed", e);
        }
    }

    private static ExecutorService createThreadPool(String name, int coreSize) {
        return new ThreadPoolExecutor(coreSize, coreSize * 2, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(1000), r -> new Thread(r, name + "-" + System.identityHashCode(r)), new ThreadPoolExecutor.CallerRunsPolicy());
    }

    private static void safeInit(Runnable initTask, String systemName) {
        try {
            initTask.run();
            if (((Boolean)CoolConfig.DEBUG_LOGGING.get()).booleanValue()) {
                LOGGER.debug("{} initialized successfully", (Object)systemName);
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to initialize {}", (Object)systemName, (Object)e);
            if (AsyncHandler.class.getAnnotation(AsyncHandler.class).fallbackToSync()) {
                if (((Boolean)CoolConfig.DEBUG_LOGGING.get()).booleanValue()) {
                    LOGGER.warn("Falling back to synchronous mode for {}", (Object)systemName);
                }
            }
            throw new RuntimeException("Critical failure in " + systemName, e);
        }
    }

    private static void registerEventHandlers() {
        MinecraftForge.EVENT_BUS.register(StructureGenAsync.class);
        MinecraftForge.EVENT_BUS.register(AsyncAIManager.class);
        MinecraftForge.EVENT_BUS.register(AsyncCollisionSystem.class);
        MinecraftForge.EVENT_BUS.register(AsyncPlayerData.class);
        MinecraftForge.EVENT_BUS.register(AsyncResourceLoader.class);
        MinecraftForge.EVENT_BUS.register(AsyncRedstone.class);
        MinecraftForge.EVENT_BUS.register(AsyncSoundSystem.class);
    }

    public static ExecutorService getThreadPool(String poolType) {
        if (shutdownInProgress.get()) {
            throw new IllegalStateException("Async system is shutting down");
        }
        return switch (poolType) {
            case "io" -> ioThreadPool;
            case "compute" -> computationThreadPool;
            default -> defaultThreadPool;
        };
    }

    public static void shutdown() {
        if (!initialized.get() || !shutdownInProgress.compareAndSet(false, true)) {
            return;
        }
        LOGGER.info("Shutting down async system...");
        AsyncSystemInitializer.safeShutdown(AsyncSoundSystem::shutdown, "AsyncSoundSystem");
        AsyncSystemInitializer.safeShutdown(AsyncRedstone::shutdown, "AsyncRedstone");
        AsyncSystemInitializer.safeShutdown(AsyncResourceLoader::shutdown, "AsyncResourceLoader");
        AsyncSystemInitializer.safeShutdown(AsyncPlayerData::shutdown, "AsyncPlayerData");
        AsyncSystemInitializer.safeShutdown(AsyncCollisionSystem::shutdown, "AsyncCollisionSystem");
        AsyncSystemInitializer.safeShutdown(AsyncAIManager::shutdown, "AsyncAIManager");
        AsyncSystemInitializer.safeShutdown(StructureGenAsync::shutdown, "StructureGenAsync");
        AsyncSystemInitializer.shutdownThreadPool(defaultThreadPool, "DefaultThreadPool");
        AsyncSystemInitializer.shutdownThreadPool(ioThreadPool, "IOThreadPool");
        AsyncSystemInitializer.shutdownThreadPool(computationThreadPool, "ComputationThreadPool");
        LOGGER.info("Async system shutdown complete");
    }

    private static void safeShutdown(Runnable shutdownTask, String systemName) {
        try {
            shutdownTask.run();
            LOGGER.debug("{} shutdown successfully", (Object)systemName);
        }
        catch (Exception e) {
            LOGGER.error("Failed to shutdown {}", (Object)systemName, (Object)e);
        }
    }

    private static void shutdownThreadPool(ExecutorService pool, String poolName) {
        if (pool == null) {
            return;
        }
        try {
            pool.shutdown();
            if (!pool.awaitTermination(5L, TimeUnit.SECONDS)) {
                pool.shutdownNow();
                if (((Boolean)CoolConfig.DEBUG_LOGGING.get()).booleanValue()) {
                    LOGGER.warn("Had to force shutdown {}", (Object)poolName);
                }
            } else if (((Boolean)CoolConfig.DEBUG_LOGGING.get()).booleanValue()) {
                LOGGER.debug("{} shutdown gracefully", (Object)poolName);
            }
        }
        catch (InterruptedException e) {
            pool.shutdownNow();
            Thread.currentThread().interrupt();
            LOGGER.warn("Interrupted while shutting down {}", (Object)poolName);
        }
    }
}

