/*
 * Decompiled with CFR 0.152.
 */
package net.carbonmc.graphene.async.sound;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import net.carbonmc.graphene.async.AsyncSystemInitializer;
import net.carbonmc.graphene.event.AsyncHandler;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@AsyncHandler(threadPool="default", fallbackToSync=true)
public class AsyncSoundSystem {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final BlockingQueue<SoundTask> soundQueue = new LinkedBlockingQueue<SoundTask>(1000);
    private static final Map<UUID, SoundTask> pendingSounds = new ConcurrentHashMap<UUID, SoundTask>();
    private static final int MAX_SOUNDS_PER_TICK = 50;
    private static final Semaphore soundSemaphore = new Semaphore(500);

    public static void init() {
        LOGGER.info("Async Sound System initialized");
    }

    public static void shutdown() {
        soundQueue.clear();
        pendingSounds.clear();
        LOGGER.info("Async Sound System shutdown completed");
    }

    public static void playSoundIfInRangeAsync(ServerPlayer player, SoundEvent sound, SoundSource category, Vec3 pos, float volume, float pitch) {
        if (player == null || sound == null || pos == null) {
            LOGGER.warn("Invalid parameters for sound playback");
            return;
        }
        if (player.m_213877_() || !player.m_6084_()) {
            LOGGER.debug("Attempted to play sound for removed/inactive player");
            return;
        }
        if (!soundSemaphore.tryAcquire()) {
            LOGGER.warn("Too many concurrent sound requests, skipping sound for {}", (Object)player.m_7755_().getString());
            return;
        }
        SoundTask task = new SoundTask(player, sound, category, pos, volume, pitch);
        if (soundQueue.offer(task)) {
            pendingSounds.put(player.m_20148_(), task);
        } else {
            soundSemaphore.release();
            LOGGER.warn("Sound queue full, skipping sound for {}", (Object)player.m_7755_().getString());
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            AsyncSoundSystem.processSoundTasks();
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        Player player;
        if (event.phase == TickEvent.Phase.END && (player = event.player) instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            AsyncSoundSystem.processPlayerSounds(player2);
        }
    }

    private static void processSoundTasks() {
        int processed = 0;
        while (processed < 50 && !soundQueue.isEmpty()) {
            SoundTask task = (SoundTask)soundQueue.poll();
            if (task == null) continue;
            ++processed;
            AsyncSystemInitializer.getThreadPool("default").execute(() -> {
                try {
                    AsyncSoundSystem.checkSoundRange(task);
                }
                finally {
                    soundSemaphore.release();
                }
            });
        }
    }

    private static void checkSoundRange(SoundTask task) {
        try {
            ServerPlayer player = task.player();
            if (player.m_213877_() || !player.m_6084_()) {
                LOGGER.debug("Player not available for sound playback");
                return;
            }
            double distanceSqr = player.m_20275_(task.pos().f_82479_, task.pos().f_82480_, task.pos().f_82481_);
            if (distanceSqr <= (double)(task.volume() * task.volume()) * 256.0) {
                task.withinRange().set(true);
            }
        }
        catch (Exception e) {
            LOGGER.error("Sound range check failed", (Throwable)e);
        }
    }

    private static void processPlayerSounds(ServerPlayer player) {
        SoundTask task = pendingSounds.get(player.m_20148_());
        if (task != null && task.withinRange().get()) {
            try {
                player.f_8906_.m_9829_((Packet)new ClientboundSoundPacket(Holder.m_205709_((Object)task.sound()), task.category(), task.pos().f_82479_, task.pos().f_82480_, task.pos().f_82481_, task.volume(), task.pitch(), player.m_9236_().m_213780_().m_188505_()));
                LOGGER.debug("Sound played for {}: {}", (Object)player.m_7755_().getString(), (Object)BuiltInRegistries.f_256894_.m_7981_((Object)task.sound()));
            }
            catch (Exception e) {
                LOGGER.error("Failed to send sound packet to {}", (Object)player.m_7755_().getString(), (Object)e);
            }
            finally {
                pendingSounds.remove(player.m_20148_());
            }
        }
    }

    private static class SoundTask {
        private final ServerPlayer player;
        private final SoundEvent sound;
        private final SoundSource category;
        private final Vec3 pos;
        private final float volume;
        private final float pitch;
        private final AtomicBoolean withinRange = new AtomicBoolean(false);

        public SoundTask(ServerPlayer player, SoundEvent sound, SoundSource category, Vec3 pos, float volume, float pitch) {
            this.player = player;
            this.sound = sound;
            this.category = category;
            this.pos = pos;
            this.volume = volume;
            this.pitch = pitch;
        }

        public ServerPlayer player() {
            return this.player;
        }

        public SoundEvent sound() {
            return this.sound;
        }

        public SoundSource category() {
            return this.category;
        }

        public Vec3 pos() {
            return this.pos;
        }

        public float volume() {
            return this.volume;
        }

        public float pitch() {
            return this.pitch;
        }

        public AtomicBoolean withinRange() {
            return this.withinRange;
        }
    }
}

