/*
 * Decompiled with CFR 0.152.
 */
package net.carbonmc.graphene.mixin.chunk;

class CellCountKey {
    private final long seed;
    private final int cellX;
    private final int cellZ;
    private final boolean isHorizontal;
    private final int hashCode;

    public CellCountKey(long seed, int cellX, int cellZ, boolean isHorizontal) {
        this.seed = seed;
        this.cellX = cellX;
        this.cellZ = cellZ;
        this.isHorizontal = isHorizontal;
        this.hashCode = this.computeHashCode();
    }

    private int computeHashCode() {
        int result = (int)(this.seed ^ this.seed >>> 32);
        result = 31 * result + this.cellX;
        result = 31 * result + this.cellZ;
        result = 31 * result + (this.isHorizontal ? 1 : 0);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CellCountKey that = (CellCountKey)o;
        return this.seed == that.seed && this.cellX == that.cellX && this.cellZ == that.cellZ && this.isHorizontal == that.isHorizontal;
    }

    public int hashCode() {
        return this.hashCode;
    }
}

