/*
 * Decompiled with CFR 0.152.
 */
package net.carbonmc.graphene.mixin.villager;

import net.carbonmc.graphene.config.CoolConfig;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.schedule.Activity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Villager.class})
public abstract class VillagerMoveOptimizationMixin {
    @Unique
    private boolean graphene$isFullyStopped = false;

    @Inject(method={"customServerAiStep"}, at={@At(value="HEAD")}, cancellable=true)
    private void onCustomServerAiStep(CallbackInfo ci) {
        if (!((Boolean)CoolConfig.VILLAGER_MOVE_OPTIMIZE.get()).booleanValue()) {
            return;
        }
        Villager villager = (Villager)this;
        if (!(villager.m_9236_() instanceof ServerLevel)) {
            return;
        }
        if (this.shouldCompletelyStopAI(villager)) {
            if (!this.graphene$isFullyStopped) {
                this.fullyStopVillagerAI(villager);
                this.graphene$isFullyStopped = true;
            }
            ci.cancel();
        } else if (this.graphene$isFullyStopped) {
            this.restoreVillagerAI(villager);
            this.graphene$isFullyStopped = false;
        }
    }

    @Unique
    private boolean shouldCompletelyStopAI(Villager villager) {
        return !this.isPlayerNearby(villager) && !this.isTrading(villager);
    }

    @Unique
    private void fullyStopVillagerAI(Villager villager) {
        Brain brain = villager.m_6274_();
        brain.m_21933_((ServerLevel)villager.m_9236_(), (LivingEntity)villager);
        brain.m_21889_(Activity.f_37979_);
        villager.m_21573_().m_26573_();
        villager.m_5616_(villager.m_146908_());
    }

    @Unique
    private void restoreVillagerAI(Villager villager) {
        villager.m_6274_().m_21862_(villager.m_9236_().m_46468_(), villager.m_9236_().m_46467_());
    }

    @Unique
    private boolean isPlayerNearby(Villager villager) {
        return villager.m_9236_().m_6907_().stream().anyMatch(player -> villager.m_20280_((Entity)player) < 256.0);
    }

    @Unique
    private boolean isTrading(Villager villager) {
        return villager.m_7962_() != null;
    }
}

