/*
 * Decompiled with CFR 0.152.
 */
package net.carbonmc.graphene.util;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.carbonmc.graphene.config.CoolConfig;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber
public final class PearlsChunkMap
extends SavedData {
    private static final String DATA_NAME = "graphene_pearls";
    private static final Logger LOGGER = LogManager.getLogger();
    private final SetMultimap<UUID, ChunkPos> map = HashMultimap.create();
    public static PearlsChunkMap INSTANCE;

    public static PearlsChunkMap get(ServerLevel level) {
        return (PearlsChunkMap)level.m_8895_().m_164861_(PearlsChunkMap::load, PearlsChunkMap::new, DATA_NAME);
    }

    public void add(UUID owner, ChunkPos pos, ServerLevel level) {
        if (!((Boolean)CoolConfig.FIX_PEARL_LEAK.get()).booleanValue()) {
            return;
        }
        PearlsChunkMap.get((ServerLevel)level).map.put((Object)owner, (Object)pos);
        level.m_8602_(pos.f_45578_, pos.f_45579_, true);
        PearlsChunkMap.get(level).m_77762_();
        if (((Boolean)CoolConfig.DEBUG_LOGGING.get()).booleanValue()) {
            LOGGER.debug("Pearl forced chunk {} in {}", (Object)pos, (Object)level.m_46472_().m_135782_());
        }
    }

    public void remove(UUID owner, ServerLevel level) {
        PearlsChunkMap data = PearlsChunkMap.get(level);
        Set set = data.map.removeAll((Object)owner);
        if (set != null) {
            set.forEach(p -> level.m_8602_(p.f_45578_, p.f_45579_, false));
            data.m_77762_();
            LOGGER.debug("Unforced {} chunks for {}", (Object)set.size(), (Object)owner);
        }
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone evt) {
        Level level;
        if (evt.isWasDeath() && (level = evt.getEntity().m_9236_()) instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            UUID uuid = evt.getOriginal().m_20148_();
            PearlsChunkMap.get(sl).remove(uuid, sl);
        }
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.LevelTickEvent evt) {
        ServerLevel sl;
        Level level;
        if (evt.phase == TickEvent.Phase.END && (level = evt.level) instanceof ServerLevel && (sl = (ServerLevel)level).m_7654_().m_129921_() % 6000 == 0) {
            PearlsChunkMap.get(sl).m_77762_();
        }
    }

    @Nonnull
    public CompoundTag m_7176_(@Nonnull CompoundTag tag) {
        ListTag list = new ListTag();
        this.map.asMap().forEach((uuid, poses) -> {
            CompoundTag entry = new CompoundTag();
            entry.m_128362_("Owner", uuid);
            ListTag chunks = new ListTag();
            poses.forEach(p -> chunks.add((Object)StringTag.m_129297_((String)p.toString())));
            entry.m_128365_("Chunks", (Tag)chunks);
            list.add((Object)entry);
        });
        tag.m_128365_("Entries", (Tag)list);
        return tag;
    }

    public static PearlsChunkMap load(CompoundTag tag) {
        PearlsChunkMap data = new PearlsChunkMap();
        ListTag list = tag.m_128437_("Entries", 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag entry = list.m_128728_(i);
            UUID owner = entry.m_128342_("Owner");
            ListTag chunks = entry.m_128437_("Chunks", 8);
            for (int j = 0; j < chunks.size(); ++j) {
                String s = chunks.m_128778_(j);
                ChunkPos pos = new ChunkPos(Long.parseLong(s));
                data.map.put((Object)owner, (Object)pos);
            }
        }
        return data;
    }

    public static void onServerStarted(MinecraftServer server) {
        for (ServerLevel level : server.m_129785_()) {
            PearlsChunkMap data = PearlsChunkMap.get(level);
            data.map.asMap().forEach((uuid, poses) -> poses.forEach(p -> level.m_8602_(p.f_45578_, p.f_45579_, true)));
            LOGGER.info("Graphene: restored {} forced chunks in {}", (Object)data.map.size(), (Object)level.m_46472_().m_135782_());
        }
    }
}

