/*
 * Decompiled with CFR 0.152.
 */
package net.carbonmc.graphene.async.chunk;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import net.carbonmc.graphene.Graphene;
import net.carbonmc.graphene.config.CoolConfig;
import net.carbonmc.graphene.optimization.chunk.ChunkOptif;
import net.carbonmc.graphene.optimization.math.random.FastRandom;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.event.level.ChunkEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class ALS {
    private static final ThreadLocal<FastRandom> THREAD_LOCAL_RANDOM = ThreadLocal.withInitial(() -> new FastRandom(0L));
    private static final AtomicLong PROCESSED_CHUNKS = new AtomicLong(0L);
    private static final int BATCH_SIZE = 16;

    @SubscribeEvent
    public static void onChunkLoad(ChunkEvent.Load event) {
        if (!((Boolean)CoolConfig.CTU.get()).booleanValue()) {
            return;
        }
        LevelAccessor level = event.getLevel();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (!serverLevel.m_46472_().m_135782_().m_135815_().equals("overworld")) {
            return;
        }
        ChunkPos pos = event.getChunk().m_7697_();
        ALS.processChunkPostLoadNonBlocking(serverLevel, pos);
    }

    private static void processChunkPostLoadNonBlocking(ServerLevel level, ChunkPos pos) {
        if (level.m_7654_().m_129918_() || Graphene.CKU.isShuttingDown()) {
            return;
        }
        if (Graphene.CHUNK_CACHE.getIfPresent((Object)pos) != null) {
            return;
        }
        long seed = level.m_7328_();
        CompletableFuture<int[]> future = Graphene.CKU.ad(() -> ALS.generateChunkFeatureData(seed, pos.f_45578_, pos.f_45579_));
        ((CompletableFuture)future.thenAcceptAsync(result -> {
            ALS.cacheChunkProcessingResult(pos, result);
            PROCESSED_CHUNKS.incrementAndGet();
            if (PROCESSED_CHUNKS.get() % 16L == 0L) {
                level.m_7654_().execute(() -> {
                    ALS.markChunkForSaving(level, pos);
                    ChunkOptif.cleanupThreadState();
                });
            } else {
                level.m_7654_().execute(() -> ALS.markChunkForSaving(level, pos));
            }
        }, (Executor)Graphene.CKU.q)).exceptionally(throwable -> {
            ChunkOptif.cleanupThreadState();
            return null;
        });
    }

    private static void markChunkForSaving(ServerLevel level, ChunkPos pos) {
        try {
            LevelChunk chunk = level.m_6325_(pos.f_45578_, pos.f_45579_);
            if (chunk != null && !chunk.m_6344_()) {
                chunk.m_8092_(true);
            }
        }
        catch (Exception exception) {
        }
        finally {
            ChunkOptif.cleanupThreadState();
        }
    }

    private static int[] generateChunkFeatureData(long seed, int chunkX, int chunkZ) {
        int[] featureData = new int[256];
        FastRandom random = THREAD_LOCAL_RANDOM.get();
        long chunkSeed = seed ^ (long)chunkX << 32 ^ (long)chunkZ;
        random.m_188584_(chunkSeed);
        for (int i = 0; i < 256; ++i) {
            featureData[i] = random.m_188502_() & Integer.MAX_VALUE;
        }
        return featureData;
    }

    private static void cacheChunkProcessingResult(ChunkPos pos, int[] result) {
        if (result != null && result.length == 256) {
            Graphene.CHUNK_CACHE.put((Object)pos, (Object)result);
        }
    }

    public static long getProcessedChunkCount() {
        return PROCESSED_CHUNKS.get();
    }

    public static void resetStats() {
        PROCESSED_CHUNKS.set(0L);
    }
}

