/*
 * Decompiled with CFR 0.152.
 */
package net.carbonmc.graphene.async.chunk;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import net.carbonmc.graphene.async.chunk.Executor;
import net.carbonmc.graphene.config.CoolConfig;
import net.carbonmc.graphene.optimization.chunk.GlobalExecutorManager;

public final class ChunkPool
implements AutoCloseable {
    private static final AtomicInteger INSTANCE_COUNT = new AtomicInteger(0);
    public volatile ExecutorService p;
    public volatile ExecutorService q;
    private volatile int cpuThreads = -1;
    private volatile int ioThreads = -1;
    private volatile long lastRebuildTime = 0L;
    private final String instanceId = "ChunkPool-" + INSTANCE_COUNT.incrementAndGet();
    private volatile boolean shuttingDown = false;

    public ChunkPool() {
        if (((Boolean)CoolConfig.CTU.get()).booleanValue()) {
            this.a();
            GlobalExecutorManager.registerResource(this);
        }
    }

    private int calculateOptimalCpuThreads() {
        int configuredThreads = (Integer)CoolConfig.CHUNKIO_THREADS.get();
        if (configuredThreads > 0) {
            return Math.max(2, configuredThreads);
        }
        int availableProcessors = Runtime.getRuntime().availableProcessors();
        if (availableProcessors <= 4) {
            return Math.max(2, availableProcessors - 1);
        }
        if (availableProcessors <= 8) {
            return availableProcessors - 2;
        }
        return Math.max(4, availableProcessors / 2);
    }

    private int calculateOptimalIoThreads(int cpuThreadCount) {
        int configuredIoThreads = (Integer)CoolConfig.CHUNKIO_THREADS.get();
        if (configuredIoThreads > 0) {
            return configuredIoThreads;
        }
        return Math.max(2, Math.min(cpuThreadCount, Runtime.getRuntime().availableProcessors() > 8 ? 6 : 4));
    }

    private int getCpuQueueSize() {
        return Math.max(256, (Integer)CoolConfig.CPU_QUEUE.get());
    }

    private int getIoQueueSize() {
        return Math.max(128, (Integer)CoolConfig.IO_QUEUE.get());
    }

    public synchronized void a() {
        if (!((Boolean)CoolConfig.CTU.get()).booleanValue()) {
            return;
        }
        if (this.shouldRebuildExecutors()) {
            int desiredCpuThreads = this.calculateOptimalCpuThreads();
            int desiredIoThreads = this.calculateOptimalIoThreads(desiredCpuThreads);
            ChunkPool.shutdownExecutor(this.p);
            ChunkPool.shutdownExecutor(this.q);
            this.p = this.createOptimizedCpuExecutor(desiredCpuThreads, this.getCpuQueueSize());
            this.q = this.createOptimizedIoExecutor(desiredIoThreads, this.getIoQueueSize());
            this.cpuThreads = desiredCpuThreads;
            this.ioThreads = desiredIoThreads;
            this.lastRebuildTime = System.currentTimeMillis();
        }
    }

    public synchronized void v() {
        if (!((Boolean)CoolConfig.CTU.get()).booleanValue()) {
            return;
        }
        this.cpuThreads = -1;
        this.ioThreads = -1;
        this.a();
    }

    private boolean shouldRebuildExecutors() {
        if (this.p == null || this.p.isShutdown() || this.q == null || this.q.isShutdown()) {
            return true;
        }
        int desiredCpuThreads = this.calculateOptimalCpuThreads();
        int desiredIoThreads = this.calculateOptimalIoThreads(desiredCpuThreads);
        return this.cpuThreads != desiredCpuThreads || this.ioThreads != desiredIoThreads;
    }

    private static void shutdownExecutor(ExecutorService executor) {
        if (executor == null) {
            return;
        }
        try {
            executor.shutdown();
            if (!executor.awaitTermination(1L, TimeUnit.SECONDS)) {
                executor.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            executor.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    public <T> CompletableFuture<T> ad(Supplier<T> taskSupplier) {
        if (this.shuttingDown || !((Boolean)CoolConfig.CTU.get()).booleanValue()) {
            return CompletableFuture.failedFuture(new RejectedExecutionException("ChunkPool is shutting down or disabled"));
        }
        this.a();
        return CompletableFuture.supplyAsync(taskSupplier, this.p);
    }

    public void af() {
        ChunkPool.shutdownExecutor(this.p);
        ChunkPool.shutdownExecutor(this.q);
        this.p = null;
        this.q = null;
        this.cpuThreads = -1;
        this.ioThreads = -1;
    }

    public void shutdownGracefully() {
        this.shuttingDown = true;
        ChunkPool.shutdownExecutor(this.p);
        ChunkPool.shutdownExecutor(this.q);
    }

    @Override
    public void close() {
        this.shutdownGracefully();
    }

    private boolean canSubmit() {
        return !this.shuttingDown && (Boolean)CoolConfig.CTU.get() != false;
    }

    private ExecutorService createOptimizedCpuExecutor(int threads, int queueSize) {
        return new Executor(threads, queueSize, "Graphene-CPU-" + this.instanceId);
    }

    private ExecutorService createOptimizedIoExecutor(int threads, int queueSize) {
        return new Executor(threads, queueSize, "Graphene-IO-" + this.instanceId);
    }

    public boolean isShuttingDown() {
        return this.shuttingDown;
    }

    public int getCpuThreadCount() {
        return this.cpuThreads;
    }

    public int getIoThreadCount() {
        return this.ioThreads;
    }

    public long getLastRebuildTime() {
        return this.lastRebuildTime;
    }

    public boolean isHealthy() {
        return this.p != null && !this.p.isShutdown() && this.q != null && !this.q.isShutdown();
    }
}

