/*
 * Decompiled with CFR 0.152.
 */
package net.carbonmc.graphene.engine.cull;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;

public class CullingEngine {
    private static final double MAX_ENTITY_CHECK_VOLUME = 61440.0;
    private final Minecraft client;
    private final Set<ChunkPos> visibleChunks = new HashSet<ChunkPos>();
    private boolean enabled = true;

    public CullingEngine(Minecraft client) {
        this.client = client;
    }

    public void updateVisibleChunks(ClientLevel world, int renderDistance) {
        this.visibleChunks.clear();
        if (this.client.f_91074_ == null) {
            return;
        }
        SectionPos center = SectionPos.m_123199_((BlockPos)this.client.f_91074_.m_20183_());
        int radius = Math.min(renderDistance, 32);
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                if (x * x + z * z > radius * radius) continue;
                this.visibleChunks.add(new ChunkPos(center.m_123170_() + x, center.m_123222_() + z));
            }
        }
    }

    public boolean shouldRenderEntity(Entity entity) {
        if (!this.enabled) {
            return true;
        }
        if (this.client.m_91314_(entity) || entity.m_6052_()) {
            return true;
        }
        AABB box = entity.m_6921_();
        if (this.isInfiniteExtentsBox(box) || this.isVeryLargeBox(box)) {
            return true;
        }
        return this.isBoxVisible(box.f_82288_, box.f_82289_, box.f_82290_, box.f_82291_, box.f_82292_, box.f_82293_);
    }

    public boolean shouldRenderBlockEntity(BlockEntity blockEntity) {
        if (!this.enabled) {
            return true;
        }
        if (blockEntity.hasCustomOutlineRendering((Player)this.client.f_91074_)) {
            return true;
        }
        AABB box = blockEntity.getRenderBoundingBox();
        return this.isBoxVisible(box.f_82288_, box.f_82289_, box.f_82290_, box.f_82291_, box.f_82292_, box.f_82293_);
    }

    private boolean isBoxVisible(double x1, double y1, double z1, double x2, double y2, double z2) {
        int minX = SectionPos.m_175552_((double)(x1 - 0.5));
        int minZ = SectionPos.m_175552_((double)(z1 - 0.5));
        int maxX = SectionPos.m_175552_((double)(x2 + 0.5));
        int maxZ = SectionPos.m_175552_((double)(z2 + 0.5));
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                if (!this.visibleChunks.contains(new ChunkPos(x, z))) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isInfiniteExtentsBox(AABB box) {
        return Double.isInfinite(box.f_82288_) || Double.isInfinite(box.f_82289_) || Double.isInfinite(box.f_82290_) || Double.isInfinite(box.f_82291_) || Double.isInfinite(box.f_82292_) || Double.isInfinite(box.f_82293_);
    }

    private boolean isVeryLargeBox(AABB box) {
        double volume = (box.f_82291_ - box.f_82288_) * (box.f_82292_ - box.f_82289_) * (box.f_82293_ - box.f_82290_);
        return volume > 61440.0;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

