/*
 * Decompiled with CFR 0.152.
 */
package net.carbonmc.graphene.engine.cull;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import net.carbonmc.graphene.config.CoolConfig;
import net.carbonmc.graphene.engine.cull.AsyncTracer;
import net.carbonmc.graphene.engine.cull.LeafOptiEngine;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public final class RenderOptimizer {
    private static final AtomicBoolean INITIALIZED = new AtomicBoolean(false);
    private static final AtomicBoolean FALLBACK_MODE = new AtomicBoolean(false);
    private static ExecutorService tracerPool;
    private static ScheduledExecutorService timeoutChecker;
    private static ScheduledExecutorService cacheCleaner;
    private static final Cache<Integer, Boolean> ENTITY_CACHE;
    private static final Cache<Long, Boolean> BLOCK_CACHE;

    public static void initialize() {
        if (INITIALIZED.getAndSet(true)) {
            return;
        }
        int threads = Math.max(1, (Integer)CoolConfig.tracingThreads.get());
        tracerPool = Executors.newWorkStealingPool(threads);
        timeoutChecker = Executors.newSingleThreadScheduledExecutor();
        cacheCleaner = Executors.newSingleThreadScheduledExecutor();
        cacheCleaner.scheduleAtFixedRate(() -> {
            if (FALLBACK_MODE.get() && System.currentTimeMillis() % 60000L < 100L) {
                FALLBACK_MODE.set(false);
            }
        }, 1L, 1L, TimeUnit.SECONDS);
    }

    public static void shutdown() {
        if (tracerPool != null) {
            tracerPool.shutdownNow();
        }
        if (timeoutChecker != null) {
            timeoutChecker.shutdownNow();
        }
        if (cacheCleaner != null) {
            cacheCleaner.shutdownNow();
        }
    }

    public static boolean shouldSkipEntity(Entity entity) {
        if (!((Boolean)CoolConfig.useAsyncTracing.get()).booleanValue()) {
            return false;
        }
        if (FALLBACK_MODE.get()) {
            return RenderOptimizer.fallbackEntityCheck(entity);
        }
        int entityId = entity.m_19879_();
        Boolean cached = (Boolean)ENTITY_CACHE.getIfPresent((Object)entityId);
        if (cached != null) {
            return cached;
        }
        Vec3 eyePos = RenderOptimizer.getCameraPosition();
        Vec3 targetPos = entity.m_20191_().m_82399_();
        boolean result = (Boolean)((CompletableFuture)AsyncTracer.traceAsync(eyePos, targetPos, (BlockGetter)entity.m_9236_()).exceptionally(e -> {
            FALLBACK_MODE.set(true);
            return RenderOptimizer.fallbackEntityCheck(entity);
        })).join();
        ENTITY_CACHE.put((Object)entityId, (Object)result);
        return result;
    }

    public static boolean shouldCullBlockFace(BlockGetter level, BlockPos pos, Direction face) {
        if (!((Boolean)CoolConfig.useAsyncTracing.get()).booleanValue()) {
            return false;
        }
        if (FALLBACK_MODE.get()) {
            return LeafOptiEngine.checkSimpleConnection(level, pos.m_121945_(face), face);
        }
        Vec3 start = RenderOptimizer.getFaceCenter(pos, face);
        Vec3 end = start.m_82549_(new Vec3((double)face.m_122429_() * (Double)CoolConfig.traceDistance.get(), (double)face.m_122430_() * (Double)CoolConfig.traceDistance.get(), (double)face.m_122431_() * (Double)CoolConfig.traceDistance.get()));
        long posKey = pos.m_121878_();
        Boolean cached = (Boolean)BLOCK_CACHE.getIfPresent((Object)posKey);
        if (cached != null) {
            return cached;
        }
        try {
            boolean result = ((CompletableFuture)RenderOptimizer.traceAsync(start, end, level).exceptionally(e -> {
                FALLBACK_MODE.set(true);
                return LeafOptiEngine.checkSimpleConnection(level, pos.m_121945_(face));
            })).getNow(false);
            BLOCK_CACHE.put((Object)posKey, (Object)result);
            return result;
        }
        catch (Exception e2) {
            FALLBACK_MODE.set(true);
            return LeafOptiEngine.checkSimpleConnection(level, pos.m_121945_(face), face);
        }
    }

    private static CompletableFuture<Boolean> traceAsync(Vec3 start, Vec3 end, BlockGetter level) {
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        Future<?> task = tracerPool.submit(() -> {
            try {
                if (Thread.interrupted()) {
                    return;
                }
                future.complete(RenderOptimizer.traceVisibility(start, end, level));
            }
            catch (Exception e) {
                future.completeExceptionally(e);
            }
        });
        timeoutChecker.schedule(() -> {
            if (!future.isDone()) {
                task.cancel(true);
                future.complete(false);
            }
        }, 1L, TimeUnit.MINUTES);
        return future;
    }

    private static boolean traceVisibility(Vec3 start, Vec3 end, BlockGetter level) {
        Vec3 direction = end.m_82546_(start);
        double distance = direction.m_82553_();
        if (distance < 0.001) {
            return true;
        }
        direction = direction.m_82541_();
        double stepSize = Math.min(0.5, distance / 8.0);
        BlockPos.MutableBlockPos mpos = new BlockPos.MutableBlockPos();
        Vec3 current = start;
        while (current.m_82554_(start) < distance) {
            if (Thread.interrupted()) {
                return false;
            }
            mpos.m_122169_(current.f_82479_, current.f_82480_, current.f_82481_);
            BlockState state = level.m_8055_((BlockPos)mpos);
            if (!state.m_60795_() && state.m_60812_(level, (BlockPos)mpos).m_83215_().m_82338_((BlockPos)mpos).m_82390_(current)) {
                return false;
            }
            current = current.m_82549_(direction.m_82490_(stepSize));
        }
        return true;
    }

    private static boolean fallbackEntityCheck(Entity entity) {
        double dist = RenderOptimizer.getCameraPosition().m_82554_(entity.m_20182_());
        return dist > (Double)CoolConfig.fallbackDistance.get();
    }

    private static Vec3 getCameraPosition() {
        return Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
    }

    private static Vec3 getFaceCenter(BlockPos pos, Direction face) {
        return new Vec3((double)pos.m_123341_() + 0.5 + (double)face.m_122429_() * 0.501, (double)pos.m_123342_() + 0.5 + (double)face.m_122430_() * 0.501, (double)pos.m_123343_() + 0.5 + (double)face.m_122431_() * 0.501);
    }

    public static boolean isInFallbackMode() {
        return FALLBACK_MODE.get();
    }

    static {
        ENTITY_CACHE = Caffeine.newBuilder().maximumSize(1000L).expireAfterWrite(500L, TimeUnit.MILLISECONDS).build();
        BLOCK_CACHE = Caffeine.newBuilder().maximumSize(10000L).expireAfterWrite(1L, TimeUnit.SECONDS).build();
    }

    private static class CachedResult {
        final CompletableFuture<Boolean> future;
        final long timestamp = System.currentTimeMillis();

        CachedResult(CompletableFuture<Boolean> future) {
            this.future = future;
        }
    }
}

