/*
 * Decompiled with CFR 0.152.
 */
package net.carbonmc.graphene.engine.cull;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.concurrent.TimeUnit;
import net.carbonmc.graphene.config.CoolConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public final class UltraCullingEngine {
    private static final Cache<Long, Boolean> CULL_CACHE = Caffeine.newBuilder().maximumSize(10000L).expireAfterWrite(1L, TimeUnit.SECONDS).build();

    public static boolean shouldCull(BlockGetter level, BlockPos pos, Direction face) {
        if (!CoolConfig.useUltraCulling()) {
            return false;
        }
        long cacheKey = pos.m_121878_() << 8 | (long)face.ordinal();
        return (Boolean)CULL_CACHE.get((Object)cacheKey, k -> {
            Vec3 eye = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
            Vec3 dir = new Vec3((double)face.m_122429_(), (double)face.m_122430_(), (double)face.m_122431_());
            int depth = CoolConfig.ultraCullingDepth();
            BlockPos.MutableBlockPos mpos = new BlockPos.MutableBlockPos();
            for (int i = 1; i <= depth; ++i) {
                mpos.m_122178_(pos.m_123341_() + face.m_122429_() * i, pos.m_123342_() + face.m_122430_() * i, pos.m_123343_() + face.m_122431_() * i);
                BlockState state = level.m_8055_((BlockPos)mpos);
                if (state.m_60815_()) continue;
                return false;
            }
            return true;
        });
    }
}

