/*
 * Decompiled with CFR 0.152.
 */
package net.carbonmc.graphene.event;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import net.carbonmc.graphene.config.CoolConfig;
import net.carbonmc.graphene.event.AsyncEventSystem;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;

public abstract class AsyncEvent
extends Event {
    private final boolean async;
    private final EventPriority priority;
    private volatile boolean completed = false;
    private volatile boolean success = false;
    private Throwable failureCause = null;

    protected AsyncEvent(boolean async) {
        this(async, EventPriority.NORMAL);
    }

    protected AsyncEvent(boolean async, EventPriority priority) {
        this.async = async;
        this.priority = priority;
    }

    public boolean isAsync() {
        return this.async;
    }

    public EventPriority getPriority() {
        return this.priority;
    }

    public boolean isCompleted() {
        return this.completed;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public Throwable getFailureCause() {
        return this.failureCause;
    }

    public void post() {
        if (!CoolConfig.isEnabled()) {
            return;
        }
        if (this.async) {
            this.postAsync();
        } else {
            this.postSync();
        }
    }

    private void postAsync() {
        CompletableFuture<Void> future = AsyncEventSystem.executeAsync(((Object)((Object)this)).getClass(), () -> {
            long startTime = System.currentTimeMillis();
            try {
                MinecraftForge.EVENT_BUS.post((Event)this);
                this.success = true;
                this.logDuration(startTime, true);
            }
            catch (Throwable t) {
                this.handleError(t);
                throw t;
            }
            finally {
                this.completed = true;
            }
        });
        if (((Boolean)CoolConfig.WAIT_FOR_ASYNC_EVENTS.get()).booleanValue()) {
            this.waitForFuture(future);
        }
    }

    private void postSync() {
        long startTime = System.currentTimeMillis();
        try {
            MinecraftForge.EVENT_BUS.post((Event)this);
            this.success = true;
            this.logDuration(startTime, false);
        }
        catch (Throwable t) {
            this.handleError(t);
            throw t;
        }
        finally {
            this.completed = true;
        }
    }

    private void logDuration(long startTime, boolean isAsync) {
        long duration = System.currentTimeMillis() - startTime;
        if (duration > (long)(isAsync ? 100 : 50)) {
            AsyncEventSystem.LOGGER.warn("{} event {} took {}ms", (Object)(isAsync ? "Async" : "Sync"), (Object)((Object)((Object)this)).getClass().getSimpleName(), (Object)duration);
        }
    }

    private void handleError(Throwable t) {
        this.failureCause = t;
        this.success = false;
        AsyncEventSystem.LOGGER.error("Event handling failed: {}", (Object)((Object)((Object)this)).getClass().getSimpleName(), (Object)t);
    }

    private void waitForFuture(CompletableFuture<Void> future) {
        try {
            future.get(((Integer)CoolConfig.ASYNC_EVENT_TIMEOUT.get()).intValue(), TimeUnit.SECONDS);
        }
        catch (Exception e) {
            AsyncEventSystem.LOGGER.warn("Async event timed out: {}", (Object)((Object)((Object)this)).getClass().getSimpleName(), (Object)e);
        }
    }

    public void registerToBus(IEventBus bus) {
        bus.addListener(this.priority, false, ((Object)((Object)this)).getClass(), this::handleEventWrapper);
    }

    private void handleEventWrapper(Event event) {
        if (!CoolConfig.isEnabled() || !(event instanceof AsyncEvent)) {
            return;
        }
        AsyncEvent asyncEvent = (AsyncEvent)event;
        try {
            this.handleEvent(asyncEvent);
        }
        catch (Throwable t) {
            AsyncEventSystem.LOGGER.error("Handler failed for {}", (Object)event.getClass().getName(), (Object)t);
            if (((Boolean)CoolConfig.DISABLE_ASYNC_ON_ERROR.get()).booleanValue()) {
                AsyncEventSystem.registerSyncEvent(event.getClass());
            }
            throw t;
        }
    }

    protected abstract void handleEvent(AsyncEvent var1);

    public static void waitForCompletion(AsyncEvent event) {
        if (!CoolConfig.isEnabled() || event == null || !event.isAsync()) {
            return;
        }
        while (!event.isCompleted()) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
        }
    }

    public static void waitForCompletion(AsyncEvent ... events) {
        if (!CoolConfig.isEnabled() || events == null) {
            return;
        }
        for (AsyncEvent event : events) {
            AsyncEvent.waitForCompletion(event);
        }
    }
}

