/*
 * Decompiled with CFR 0.152.
 */
package net.carbonmc.graphene.optimization.oldthing;

import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import net.carbonmc.graphene.config.CoolConfig;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.EntityLeaveLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class EntityOptimizer {
    private static final Map<Entity, Long> inactiveEntities = new WeakHashMap<Entity, Long>();

    @SubscribeEvent
    public void onEntityJoin(EntityJoinLevelEvent event) {
        if (!((Boolean)CoolConfig.disableEntityCollisions.get()).booleanValue()) {
            return;
        }
        Entity entity = event.getEntity();
        entity.m_20242_(true);
        entity.f_19794_ = false;
        inactiveEntities.put(entity, System.currentTimeMillis());
    }

    @SubscribeEvent
    public void onEntityLeave(EntityLeaveLevelEvent event) {
        inactiveEntities.remove(event.getEntity());
    }

    public static void processInactiveEntities() {
        if (!((Boolean)CoolConfig.disableEntityCollisions.get()).booleanValue()) {
            return;
        }
        long now = System.currentTimeMillis();
        Iterator<Map.Entry<Entity, Long>> iterator = inactiveEntities.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Entity, Long> entry = iterator.next();
            Entity entity = entry.getKey();
            if (!entity.m_6084_()) {
                iterator.remove();
                continue;
            }
            if (now - entry.getValue() <= 10000L) continue;
            entity.m_20256_(Vec3.f_82478_);
            entity.m_6034_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
        }
    }
}

