/*
 * Decompiled with CFR 0.152.
 */
package net.carbonmc.graphene.optimization.oldthing;

import net.carbonmc.graphene.config.CoolConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.server.level.ServerLevel;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@OnlyIn(value=Dist.CLIENT)
public class MemoryCleaner {
    private long lastCleanTime = 0L;

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        long interval;
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (event.getServer().m_129783_() == null) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastCleanTime > (interval = (long)((Integer)CoolConfig.MEMORY_CLEAN_INTERVAL.get() * 1000))) {
            this.cleanupResources();
            this.lastCleanTime = currentTime;
        }
    }

    private void cleanupResources() {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null) {
            return;
        }
        if (((Boolean)CoolConfig.OPTIMIZE_ENTITY_CLEANUP.get()).booleanValue()) {
            for (ServerLevel level : mc.m_91092_().m_129785_()) {
                level.m_8583_().forEach(entity -> {
                    if (!entity.m_6084_() && entity.f_19797_ > 600) {
                        entity.m_146870_();
                    }
                });
            }
        }
        if ((long)((Integer)CoolConfig.MEMORY_CLEAN_INTERVAL.get()).intValue() > this.lastCleanTime) {
            this.cleanupResources();
            System.out.println("[Graphene] \u5185\u5b58\u6e05\u7406\u5b8c\u6210");
        }
    }
}

