/*
 * Decompiled with CFR 0.152.
 */
package net.carbonmc.graphene.optimization.chunk;

import net.carbonmc.graphene.config.CoolConfig;

public final class LightingContext {
    private static final ThreadLocal<Boolean> IS_LIGHTING = ThreadLocal.withInitial(() -> false);
    private static final ThreadLocal<Long> LIGHTING_ENTRY_TIME = ThreadLocal.withInitial(() -> 0L);
    private static final ThreadLocal<Integer> LIGHTING_DEPTH = ThreadLocal.withInitial(() -> 0);

    public static boolean isLightingThread() {
        return IS_LIGHTING.get() != false || Thread.currentThread().getName().contains("light") || Thread.currentThread().getName().contains("Light");
    }

    public static void enter() {
        if (!((Boolean)CoolConfig.CTU.get()).booleanValue()) {
            return;
        }
        IS_LIGHTING.set(true);
        LIGHTING_ENTRY_TIME.set(System.nanoTime());
        LIGHTING_DEPTH.set(LIGHTING_DEPTH.get() + 1);
    }

    public static void exit() {
        if (!((Boolean)CoolConfig.CTU.get()).booleanValue()) {
            return;
        }
        int depth = LIGHTING_DEPTH.get() - 1;
        if (depth <= 0) {
            IS_LIGHTING.remove();
            LIGHTING_ENTRY_TIME.remove();
            LIGHTING_DEPTH.remove();
        } else {
            LIGHTING_DEPTH.set(depth);
        }
    }

    public static long getCurrentLightingDuration() {
        Long entryTime = LIGHTING_ENTRY_TIME.get();
        return entryTime != null ? System.nanoTime() - entryTime : 0L;
    }

    public static void validateLightingState() {
        if (IS_LIGHTING.get().booleanValue() && LIGHTING_DEPTH.get() <= 0) {
            IS_LIGHTING.remove();
            LIGHTING_ENTRY_TIME.remove();
            LIGHTING_DEPTH.remove();
        }
    }

    private LightingContext() {
    }
}

